#!/bin/sh
#######################################################################################################################
#
# DESCRIPTION   :       LNX - Script de sauvegarde Mondorescue automatique
#
# OPTIONS DE LANCEMENT
# arguments :
#      -dir /my/dir;/other/dir -- le dossier que l'on veut purger                        (obligatoire)
#      -recursive y            -- recherche dans les sous-rpertoire                     (par dfaut: n)
#      -filetype all           -- le(s) type(s) de fichier  purger, spar par des ":"  (par dfaut: all)
#      -retention 180          -- au del de combien de jours on liste                   (par dfaut: 365)
#      -remove y               -- lancer un rm sur la liste de fichiers                  (par dfaut: n)
#      -log /tmp/testing       -- log des oprations                                     (par dfaut: /root/admin/log)
#
# EXEMPLE       :       $0 -dir /my/dir:/other/dir -recursive y -filetype .tmp:.dmp.gz:.dmp -retention 180 -rm y -log /tmp/mylog.log
#
# LOG           :       /tmp/lnx_historique_purge.log (par dfaut)
#
# MODIFICATIONS :
#                       2009/12  	: v1   : Creation 			- Camille Bouly
#                       2010/04/07  	: v1.1 : Modifications			- BLE
#						 Renommage du script
#						 Correction des erreurs
#						 Ajout usage		
#
#######################################################################################################################

#***************************************************************************
#              Variables FOR VTOM
#***************************************************************************

. ~/.bash_profile

VERSION="1.1"
ECHO_VERSION="## LNX - Script de sauvegarde Mondorescue automatique -- Version $VERSION"


SYNTAX="
$ECHO_VERSION

USAGE : $0 [ options ]
  
	-serv		: Nom du serveur ou reside le partage NFS
	
	-e  		: Filesystem  ou directory que l'on veut exclure de la sauvegarde  	
  
  	-m [i][n]	: Choix du Mode - soit i pour le mode ISO soit n pour le mode NFS  
  
 Exemple :
 $0  -m i -serv pmk0vct10 -e /dev/mapper/VolGroup00-LogVol02 pmk1ora2:/oracle/NodhosImages /PMK1JBOSS10 /srv /tftpboot >> /var/log/lnx_mondo_bkp_system.log

"




#***************************************************************************
# 		Functions
#***************************************************************************

error_syntax() {
  echo ""
  echo "$SYNTAX" >&2
  exit 1
}

#***************************************************************************
#              Variables 
#***************************************************************************


servername=`hostname`
resmondo=1
mesmondo=""
NFS_DIRECTORY=mondo_bck
MAIL_TO_SENDER=bruno.legrand@partenaire.pimkie.com

#***************************************************************************
#               MAIN
#
#***************************************************************************
#Verification du nombre d'arguments
if [[ $# -lt 1 ]]
then
  error_syntax
fi


while [ "$1" != "" ]
do
    case $1 in
    	-e) 	exclude=$2
		shift
		while [ "$2" != "-m" ] && [ "$2" != "" ]
		do 
		exclude="$exclude $2"
		shift
		done
		exclude='"'"$exclude"'"'
		shift ;;

    	-m) 	mode=$2
		shift ;;

    	-serv)	servnfs=$2
		shift ;;
        
	-version) echo "$ECHO_VERSION"; exit 49;;
  
	-help) echo "$SYNTAX"; exit 50;;
  
    esac
    shift   
done


#Mise en place du montage nfs

service nfs restart

if [ ! -d /mnt/mondo ] ; then
	mkdir -v /mnt/mondo
fi

umount /mnt/mondo

mount -t nfs $servnfs:/$NFS_DIRECTORY /mnt/mondo 

#Ajouter controle erreur



#Creation du dossier de reception au nom du serveur s'il n'existe pas

if [ ! -d /mnt/mondo/$servername ] ; then
	mkdir -v /mnt/mondo/$servername
fi

#Archivage des Infos du serveur


echo "Fiche d'identit de $servername" > /mnt/mondo/$servername//ID.txt
echo -e "\n############## Uname -a #########################\n" >> /mnt/mondo/$servername/ID.txt
uname -a >> /mnt/mondo/$servername/ID.txt
echo -e "\n############## df -h #########################\n" >> /mnt/mondo/$servername/ID.txt
df -h >> /mnt/mondo/$servername/ID.txt
echo -e "\n############## fstab #########################\n" >> /mnt/mondo/$servername/ID.txt
cat /etc/fstab >> /mnt/mondo/$servername/ID.txt
echo -e "\n############## ifconfig -a #########################\n" >> /mnt/mondo/$servername/ID.txt
ifconfig eth0 >> /mnt/mondo/$servername/ID.txt
echo -e "\n############## OS Version #########################\n" >> /mnt/mondo/$servername/ID.txt
cat /etc/redhat-release >> /mnt/mondo/$servername/ID.txt
echo -e "\n############## modprobe.conf #########################\n" >> /mnt/mondo/$servername/ID.txt
cat /etc/modprobe.conf >> /mnt/mondo/$servername/ID.txt
echo -e "\n############## Fdisk -l #########################\n" >> /mnt/mondo/$servername/ID.txt
fdisk -l >> /mnt/mondo/$servername/ID.txt
echo -e "\n############## LVM #########################\n" >> /mnt/mondo/$servername/ID.txt
pvdisplay >> /mnt/mondo/$servername/ID.txt
vgdisplay >> /mnt/mondo/$servername/ID.txt
lvdisplay >> /mnt/mondo/$servername/ID.txt
echo -e "\n############## Exclus lors de la sauvegarde #########################\n" >> /mnt/mondo/$servername/ID.txt
echo "$exclude" >> /mnt/mondo/$servername/ID.txt

#On archive l'anciennne sauvegarde (si elle existe)

if [  -e /mnt/mondo/$servername/mondorescue-1.iso ] ; then
	mv /mnt/mondo/$servername/mondorescue-1.iso /mnt/mondo/$servername/mondorescue-1.old
fi


#C'est parti!

if [ $mode = 'n' ]
        then
	echo "mode nfs"
        mondoarchive -On $servnfs:/$NFS_DIRECTORY -d "$servername" -N -E "$exclude" -s 40g   | tee /tmp/mesmondo.txt
fi

if [ $mode = 'i' ]
        then
	echo "mode iso"
	 mondoarchive -Oi -d /mnt/mondo/"$servername" -N -E "$exclude" -s 40g   | tee /tmp/mesmondo.txt
fi

resmondo=`tail /tmp/mesmondo.txt | grep result | awk -F= '{print $2}'`


#On verifie et on envoie un mail sur le statut de la sauvegarde

if [ $resmondo != 0 ]
	then
	mail -s "Probleme sur l'archivage Mondorescue du serveur $servername ; voir /var/log/mondoarchive.log" $MAIL_TO_SENDER </tmp/mesmondo.txt
	exit 1;
	else
	mail -s "OK pour l'archivage Mondorescue du serveur $servername" $MAIL_TO_SENDER </tmp/mesmondo.txt
	if [  -e /mnt/mondo/$servername/mondorescue-1.old ] ; then
		rm -f /mnt/mondo/$servername/mondorescue-1.old
	fi
	exit 0;
fi



