/* 
   $Id$
*/

#include <stdio.h>
#include <string.h>

/* New functions safe from a memory manageemnt point of view */
/* Developped by Andree Leidenfrost */
/**
 * Build a partition name from a drive and a partition number.
 * @param instr 
 * @param delims 
 * @param lastpos 
 * @return @p 
 * @note this function allocates memory that needs to be freed by caller
 **/


char *mr_strtok(char *instr, const char *delims, int *lastpos) {

char *token = NULL;
char *strptr = NULL;
size_t pos1 = 0;
size_t pos2 = 0;

if (strlen(instr) <= *lastpos) {
	*lastpos = 0;
	return token;
}

strptr = instr + *lastpos;
pos2 = strspn(strptr, delims);
strptr += pos2;
pos1 = strcspn(strptr, delims);
token = malloc(sizeof(*token)*(pos1+1));
strncpy(token, strptr, pos1);
token[pos1] = '\0';
*lastpos = *lastpos + pos1 + pos2 + 1;

return token;
}
