/* mr_conf.h
 *
 * $Id$
 *
 * based on parse_conf.h (c)2002-2004 Anton Kulchitsky  mailto:anton@kulchitsky.org
 * Review for mondorescue (c) 2006 Bruno Cornec <bruno@mondorescue.org>
 *   
 *     Header file of libmondo-conf (mr_conf): a very small and simple
 *     library for mondorescue configuration file reading
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  as published by the Free Software Foundation; either version 2.1
 *  of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA
 */

#ifndef MR_CONF_H
#define MR_CONF_H

/* functions (public methods) */

/*initialization and closing*/
int mr_conf_open(const char *filename);
void mr_conf_close();

/*read integer number after string str in the current file*/
int mr_conf_iread(const char *field_name);

/*read double/float number after string str in the current file*/
double mr_conf_fread(const char *field_name);

/*
 * read string after string str in the current file.
 * This function allocates the string which has to be freed later on 
*/
char *mr_conf_sread(const char *field_name);

#endif							/* MR_CONF_H */
