#
# Makefile for mondorescue man pages
#
# $Id$
#
MANPAGES=$(shell ls *.8)
HTMLSET=$(shell echo ${MANPAGES} | sed 's~.8~.8.html~g')
PDFSET=$(shell echo ${MANPAGES} | sed 's~.8~.8.pdf~g')
PSSET=$(shell echo ${MANPAGES} | sed 's~.8~.8.ps~g')
TXTSET=$(shell echo ${MANPAGES} | sed 's~.8~.8.txt~g')

.all-html: $(HTMLSET)
	@echo ""
	@echo "Generating Man pages in HTML format"
	@echo "-----------------------------------"
	@touch .all-html

.all-pdf: $(PDFSET)
	@echo ""
	@echo "Generating Man pages in PDF format"
	@echo "-----------------------------------------"
	@touch .all-pdf

.all-ps: $(PSSET)
	@echo ""
	@echo "Generating Man pages in PS format"
	@echo "-----------------------------------------"
	@touch .all-ps

.all-txt: $(TXTSET)
	@echo ""
	@echo "Generating Man pages in TXT format"
	@echo "----------------------------------"
	@touch .all-txt

%.8.html: %.8
	@man2html -r $< > $@

%.8.ps: %.8
	@man2dvi ./$< > $<.dvi
	@dvips -q $<.dvi -o $@
	@rm -f $<.dvi

%.8.pdf: %.8.ps
	@ps2pdf $<

%.8.txt: %.8
	@nroff -man $< > $@

all: .all-html .all-pdf .all-ps .all-txt

clean: 
	@echo ""
	@echo "Cleaning up the documentation directory for man pages"
	@echo ""
	@rm -f *.8.{dvi,pdf,ps,txt,html}

install: install-mindi install-mondo

install-mindi: all
	@echo ""
	@echo "Delivering mindi man page"
	@echo ""
	@if [ "${INSTALLDIR}" != "" ]; then mkdir -p ${INSTALLDIR} ; cp -a mindi.8.{html,pdf,ps,txt} mindi.8 ${INSTALLDIR} ; else echo "No INSTALLDIR specified aborting install"; fi

install-mondo: all
	@echo ""
	@echo "Delivering mondo man pages"
	@echo ""
	@if [ "${INSTALLDIR}" != "" ]; then mkdir -p ${INSTALLDIR} ; cp -a mondo*.8.{html,pdf,ps,txt} mondo*.8 ${INSTALLDIR} ; else echo "No INSTALLDIR specified aborting install"; fi
