/*
 * $Id$
 *
 *     Header file of mr_str.c: a set of function manipulating strings
 *     Provided under the GPL v2
 */

#ifndef MR_STR_H
#define MR_STR_H

/* Constants for mr_stresc */
#define WILDCHARS	"[]*?"
#define BACKSLASH	'\\'

/* functions (public methods) */

extern char *mr_strtok(char *instr, const char *delims, size_t *lastpos);
extern char *mr_stresc(char *instr, char *toesc, const char escchr, const char specialchr);
extern char *mr_date(void);
extern char *mr_strip_spaces(const char *instr);
extern char *mr_str_substitute(const char *in, const char *token, const char *subst);

// All safe strncpy calls are prefixed
#define mr_strncpy strncpy
/*
extern void mr_strip_char(char *in_out, char *caracs);
extern void mr_chomp(char *in_out);
*/

#endif							/* MR_STR_H */
