/* 
 * $Id$
 *
 *     Header file of mr_mem: a set of function manipulating memory
 *     Provided under the GPL v2
 */

#ifndef MR_MEM_H
#define MR_MEM_H

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#include <stdarg.h>
#include <stdio.h>
#include "mr_std.h"

/* functions (public methods) */

#define mr_free(x) mr_free_int((void **)&x,__LINE__,__FILE__)
#define mr_asprintf(x,y,args...) mr_asprintf_int((char **)&x,__LINE__,__FILE__,y,## args)
#define mr_getline(x,y) mr_getline_int((char **)&x,y,__LINE__,__FILE__)
#define mr_malloc(x) mr_malloc_int((size_t)x,__LINE__,__FILE__)
#define mr_setenv(x,y) mr_setenv_int(x,y,__LINE__,__FILE__)
#define mr_strcat(x,y,args...) mr_strcat_int((char **)&x, __LINE__,__FILE__, y,## args);

/* Internal function bringing debuging info 
 * called indirectly through macros */
MR_EXTERN void mr_free_int(void **allocated, int line, char *file);
MR_EXTERN void mr_asprintf_int(char **alloc, int line, char *file, const char *fmt, ...);
MR_EXTERN void mr_getline_int(char **lineptr, FILE *stream, int line, char *file);
MR_EXTERN void *mr_malloc_int(size_t size, int line, char *file);
MR_EXTERN void mr_setenv_int(const char *name, const char *value, int line, char *file);
extern void mr_strcat_int(char **in, int line, char *file, const char *fmt, ...);

#endif							/* MR_MEM_H */
