/*
 * $Id$
 *
 * Test program for mountlist management at restore time
 * Can be used on host system with valgrind easier than with mondorestore
 */
#include <stdio.h>
#include "my-stuff.h"
#include "mr_mem.h"
#include "../common/mondostructures.h"
#include "../common/libmondo.h"
#include "../mondorestore/mondorestore.h"
#include "../mondorestore/mr-externs.h"
#include "../mondorestore/libmondo-mountlist-EXT.h"


#define RAIDTAB_TEST "/tmp/raidtab"
#define MOUNTLIST_TEST "/tmp/mountlist.txt"

extern void twenty_seconds_til_yikes(void);

extern bool g_text_mode;
extern FILE *g_fprep;
extern double g_kernel_version;
extern int g_partition_table_locked_up;
extern int g_noof_rows;

/* Whether we should fail immediately at first error */
bool g_fail_immediately = FALSE;

bool g_ISO_restore_mode = FALSE;	/* are we in Iso Mode? */
bool g_I_have_just_nuked = FALSE;
char *g_biggielist_txt;
char *g_filelist_full;
char *g_filelist_imagedevs;
char *g_imagedevs_restthese;

char *g_mondo_cfg_file;

char *g_mountlist_fname;
//char *g_mondo_home;

//char *g_getfacl;
//char *g_getfattr;

extern char *MONDO_LOGFILE;
extern int copy_from_src_to_dest(FILE * f_orig, FILE * f_archived, char direction);
extern int create_raid_device_via_mdadm(struct raidlist_itself *raidlist, char *device, bool test);

/* Reference to global bkpinfo */
struct s_bkpinfo *bkpinfo;

/* We don't have a cleanup function yet */
void (*mr_cleanup)(void) = NULL;

int main() {

struct mountlist_itself *mountlist = NULL;
struct raidlist_itself *raidlist = NULL;
char *flaws_str = NULL;

mr_asprintf(MONDO_LOGFILE,"/tmp/mrtest-mountlist.log");

/* Globals */
g_loglevel = 99;
g_text_mode = FALSE;
g_main_pid = getpid();

if (!(mountlist = malloc(sizeof(struct mountlist_itself)))) {
	fatal_error("Cannot malloc mountlist");
}
if (!(raidlist = malloc(sizeof(struct raidlist_itself)))) {
	fatal_error("Cannot malloc raidlist");
}
malloc_libmondo_global_strings();

setup_newt_stuff();
mr_asprintf(g_mountlist_fname, MOUNTLIST_TEST);
log_it("before mountlist");
load_mountlist(mountlist, g_mountlist_fname);
log_it("after mountlist");
resize_mountlist_proportionately_to_suit_new_drives(mountlist);
log_it("after resize_mountlist_proportionately_to_suit_new_drives");
load_raidtab_into_raidlist(raidlist, RAIDTAB_TEST);
log_it("after load_raidtab_into_raidlist");
edit_mountlist(g_mountlist_fname, mountlist, raidlist);
log_it("after edit_mountlist");

flaws_str = evaluate_mountlist(mountlist);
log_it("after evaluate_mountlist");
mr_free(flaws_str);

log_it("before write again raidlist content");
save_raidlist_to_raidtab(raidlist, RAIDTAB_TEST".new");
log_it("after write again raidlist content");

log_it("before create mdadm dev");
/*
create_raid_device_via_mdadm(raidlist,"/dev/md0",FALSE);
create_raid_device_via_mdadm(raidlist,"/dev/md1",FALSE);
*/
log_it("after create mdadm dev");

free(mountlist);
free(raidlist);
mr_free(MONDO_LOGFILE);
mr_free(g_mountlist_fname);
exit(0);
}
