#!/bin/bash
#
# Script to automate mageia docker images creation.
#

# Variables management
WORKDIR=$HOME/tmp
if [ -f $HOME/.mageia-docker ]; then
	. $HOME/.mageia-docker
fi
if [ _"$GITDIR" = _"" ]; then
	GITDIR=$HOME/mageia-docker
fi

# Cleanup before doing anything
sudo rm -rf $GITDIR

# Clone again from git
git clone -q git@github.com:bcornec/mageia-docker.git $GITDIR
if [ $? -ne 0 ]; then
	git clone -q https://github.com/bcornec/mageia-docker.git $GITDIR
	if [ $? -ne 0 ]; then
		exit -1
	fi
fi

opt=""
# Detect mirror server if any
if [ _"$1" = _"-f" ]; then
	opt="-f"
	shift
fi
if [ _"$1" != _"" ]; then
	opt="$opt -m $1"
fi

# Launch script
for v in 5 6 cauldron; do
	sudo rm -rf $WORKDIR/$v
	echo "---------------------------"
	bash -x /users/bruno/prj/mageia-docker/mageia-docker -v $v -w $WORKDIR $opt
	#$GITDIR/mageia-docker -v $v -w $WORKDIR $opt
	sudo rm -rf $WORKDIR/$v
done

# Clean after run in Docker
docker container prune -f
docker image prune -f
docker images
