#!/bin/bash
#
# Script to automate mageia docker images creation.
#

# Variables management
WORKDIR=$HOME/tmp
if [ -f $HOME/.mageia-docker ]; then
	. $HOME/.mageia-docker
fi
if [ _"$GITDIR" = _"" ]; then
	GITDIR=$HOME/mageia-docker
fi

# Cleanup before doing anything
sudo rm -rf $GITDIR

# Clone again from git
git clone -q git@github.com:bcornec/mageia-docker.git $GITDIR

# Detect mirror server if any
if [ _"$1" != _"" ]; then
	opt="-m $1"
else
	opt=""
fi

# Launch script
for v in 5 6 cauldron; do
	sudo rm -rf $WORKDIR/$v
	$GITDIR/mageia-docker -v $v -w $WORKDIR $opt
	sudo rm -rf $WORKDIR/$v
done

# Clean after run in Docker
docker container prune -f
docker image prune -f
docker images
