/*
 * $Id$
 *
 * Test program for mr_str_substitute
 * Can be used on host system with valgrind easier than with mondorestore
 */
#include <stdio.h>
#include <stdlib.h>
#include "mr_str.h"
#include "mr_mem.h"
#include "my-stuff.h"

/* Whether we should fail immediately at first error */
bool g_fail_immediately = FALSE;

void (*mr_cleanup)(void) = NULL;

char *strl[] = {
		"    test  with  \n",
		"  \ttest\twith\tCDROM\t",
		NULL
};

char *strlsub[] = {
		"test  with",
		"test\twith\tCDROM",
		NULL
};

int main() {

		int i;
		char *p;

		for (i = 0; strl[i] != NULL ; i++) {
			printf("Test %2d Original chain is ***%s***\n",i,strl[i]);
			p = mr_strip_spaces(strl[i]);
			printf("Test %2d Transformed chain (stripped) is ***%s***\n",i,p);
			if (strcmp(p,strlsub[i]) != 0) {
				printf("Error for mr_strip_spaces for ***%s***\n",strl[i]);
			}
		}
exit(0);
}
