/* 
 * $Id$
 *
 *     Header file of mr_msg: a set of function manipulating messages
 *     Provided under the GPL v2
 */

#ifndef MR_MSG_H
#define MR_MSG_H

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#include <stdarg.h>

/* functions (public methods) */

#define mr_msg(lvl,fmt,args...) {mr_msg_int(lvl,__LINE__,__FILE__,__FUNCTION__,fmt,## args);}
extern void mr_msg_init(const char *logfile, int loglevel);
extern void mr_msg_close(void);
extern void mr_msg_loglevel(int loglevel);

/* Internal function bringing debuging info 
 * called indirectly through macros */
extern inline void mr_msg_int(int debug, int line, const char *file, const char *function, const char *fmt, ...);

#endif							/* MR_MSG_H */
