/*
 * $Id$
 *
 * Test program for mr_stresc
 * Can be used on host system with valgrind easier than with mondorestore
 */
#include <stdio.h>
#include <stdlib.h>
#include "mr_str.h"
#include "mr_mem.h"
#include "my-stuff.h"

/* Whether we should fail immediately at first error */
bool g_fail_immediately = FALSE;

/* Reference to global bkpinfo */
struct s_bkpinfo *bkpinfo;

void (*mr_cleanup)(void) = NULL;

char *strl[] = {
		"test with space",
		"test with \\ backslash",
		"test with \" doublequote",
		"test with ' simplequote",
		"test with ~ tilde",
		"test with ? questionmark",
		"test with ! exclammark",
		"test with & ampersand",
		"test with * star",
		"test with | pipe",
		"test with \\' backslash quote",
		"test with nothing SPECIAL 1234",
		"test with rtmp:_ retrieval with rtmpdump and tcpdump « Pxnh's Blog_files",
		NULL
};

int main() {

		char *p;
		int i;

		for (i = 0; strl[i] != NULL ; i++) {
				printf("Test %2d Original chain is %s\n",i,strl[i]);
				p = mr_stresc(strl[i], "`$\\\"(){}'[]&*?|!#~", '\\', '"');
				printf("Test %2d Transformed chain (with \") is %s\n",i,p);
				mr_free(p);
				p = mr_stresc(strl[i], "`$\\\"(){}'[]&*?|!#~", '\\', '\'');
				printf("Test %2d Transformed chain (with ') is %s\n",i,p);
				mr_free(p);
		}
exit(0);
}
