#!/usr/bin/perl -w
#
# Disk subroutines brought by the MondoRescue project
#
# $Id$
#
# Copyright B. Cornec 2008-2015
# Provided under the GPL v2

package MondoRescue::Disk;

use strict 'vars';
use ProjectBuilder::Base;
use English;

# Inherit from the "Exporter" module which handles exporting functions.

use Exporter;

# Export, by default, all the functions into the namespace of
# any code which uses this module.

our @ISA = qw(Exporter);
our @EXPORT = qw(mr_disk_type);

=pod

=head1 NAME

MondoRescue::Disk, part of the mondorescue.org

=head1 DESCRIPTION

This modules provides disk related functions for the Mondorescue project

=head1 USAGE

=over 4

=item B<mr_disk_type>

This function uses fdisk to determine the type of disk whose device is passed as a parameter
It returns either msdos for MBR type or gpt for GPT type

=cut

sub mr_disk_type {

my $device = shift;
# MBR by default
my $type = "msdos";

my $fdisk = pb_check_req("fdisk",0);

open(FDISK, "$fdisk -l $device 2>/dev/null |") || die "Unable to read from $fdisk";
while (<FDISK>) {
	if (($_ =~ /EFI GPT/) || ($_ =~ / GPT /){
		$type= "gpt";
		last;
	}
}
close(FDISK);
pb_log(2,"Found a $type partition format\n)";
return ($type);
}
