#!/bin/bash
#
# $Id: install.sh 3360 2015-03-07 13:41:11Z bruno $
#

if [ ! -f "mindi" ] ; then
    echo "Please 'cd' to the directory you have just untarred." >> /dev/stderr
    exit 1
fi

if [ "_$PREFIX" != "_" ]; then
	local=${HEAD}$PREFIX
	sublocal=$PREFIX
	if [ "_$CONFDIR" != "_" ]; then
		conf=${HEAD}$CONFDIR/mindi
		subconf=$CONFDIR/mindi
	else
		echo "CONFDIR should be defined if PREFIX is defined"
		exit -1
	fi
else
	local=/usr/local
	sublocal=$local
	if [ -f /usr/sbin/mindi ]; then
		echo "WARNING: /usr/sbin/mindi exists. You should probably remove the mindi package !"
	fi
	conf=$local/etc/mindi
	subconf=$conf
	echo $PATH | grep $local/sbin > /dev/null || echo "Warning - your PATH environmental variable is BROKEN. Please add $local/sbin to your PATH."
fi

if uname -a | grep Knoppix > /dev/null || [ -e "/ramdisk/usr" ] ; then
    local=/ramdisk/usr
	sublocal=$local
	conf=/ramdisk/etc
	subconf=$conf
    export PATH=/ramdisk/usr/sbin:/ramdisk/usr/bin:/$PATH
fi

MINDIVER=PBVER
MINDIREV=PBREV
VERSTR=${MINDIVER}-r${MINDIREV}
ARCH=`/bin/uname -m`
echo "mindi $VERSTR will be installed under $local"

if [ _"$CACHEDIR" = _"" ]; then
	CACHEDIR=$local/var/cache/mindi
else
	CACHEDIR=${HEAD}$CACHEDIR
fi
if [ _"$MANDIR" = _"" ]; then
	MANDIR=$local/share/man/man8
else
	MANDIR=${HEAD}$MANDIR/man8
fi
if [ _"$SBINDIR" = _"" ]; then
	subsbin=$local/sbin
	SBINDIR=$local/sbin
else
	subsbin=$SBINDIR
	SBINDIR=${HEAD}$SBINDIR
fi
if [ _"$DOCDIR" = _"" ]; then
	DOCDIR=$local/share/doc/mindi-$MINDIVER
else
	DOCDIR=${HEAD}$DOCDIR/mindi-$MINDIVER
fi
if [ _"$LIBDIR" = _"" ]; then
	echo $ARCH | grep -E '^i[0-9]86$' &> /dev/null && ARCH=i386 && locallib=$local/lib
	echo $ARCH | grep -E '^x86_64$' &> /dev/null && locallib=$local/lib64
	echo $ARCH | grep -E '^ia64$' &> /dev/null && locallib=$local/lib
	sublocallib="$locallib/mindi"
else
	locallib=${HEAD}$LIBDIR
	sublocallib="$LIBDIR/mindi"
fi

echo "Creating target directories ..."
install -m 755 -d $conf $locallib/mindi $MANDIR $SBINDIR $CACHEDIR $conf/deplist.d

echo "Copying files ..."
cp -af rootfs $locallib/mindi
chmod 755 $locallib/mindi/rootfs/sbin/*
install -m 755 analyze-my-lvm $locallib/mindi
install -m 644 msg-txt dev.tgz $locallib/mindi
install -m 644 deplist.txt mindi.conf README.bootparam README.pxe $conf
for f in deplist.d/*.conf; do
	install -m 644 $f $conf/deplist.d
done

# Substitute variables for mindi
sed -e "s~^MINDI_PREFIX=XXX~MINDI_PREFIX=$sublocal~" -e "s~^MINDI_CONF=YYY~MINDI_CONF=$subconf~" -e "s~^MINDI_LIB=LLL~MINDI_LIB=$sublocallib~" mindi > $SBINDIR/mindi
chmod 755 $SBINDIR/mindi
install -m 644 mindi.8 $MANDIR

# Manage perl script man pages
for s in mindi-bkphw mindi-get-perl-modules parted2fdisk.pl; do
	install -m 755 $s $SBINDIR
	pod2man -c "$s a MondoRescue tool" --section=8 --release="$VERSTR" $SBINDIR/$s > $s.8
	install -m 644 $s.8 $MANDIR
	# Generate the list of perl modules needed at restore time for mindi
	cat >> $conf/perl-scripts << EOF
$subsbin/$s
EOF
done
(cd $MANDIR ; if [ ! -f parted2fdisk.9 ]; then ln -s parted2fdisk.pl.8 parted2fdisk.9; fi)

if [ "_$PREFIX" = "_" ] && [ ! -f $locallib/mindi/rootfs/bin/busybox ]; then
	echo "WARNING: no busybox found, mindi will not work on this arch ($ARCH)"
fi

# Managing parted2fdisk
if [ "$ARCH" = "ia64" ] ; then
	(cd $SBINDIR && ln -sf parted2fdisk.pl parted2fdisk && install -m 755 $SBINDIR/parted2fdisk.pl $locallib/mindi/rootfs/sbin/parted2fdisk
else
	# FHS requires fdisk under /sbin
	(cd $SBINDIR && ln -sf ../../sbin/fdisk parted2fdisk)
	echo "Symlinking fdisk to parted2fdisk"
	( cd $locallib/mindi/rootfs/sbin && ln -sf fdisk parted2fdisk)
fi

if [ "$PKGBUILDMINDI" != "true" ]; then
	chown -R root:root $locallib/mindi $conf # $DOCDIR
	chown root:root $SBINDIR/mindi $MANDIR/mindi.8 $locallib/mindi/analyze-my-lvm $SBINDIR/parted2fdisk.pl 
	if [ "$ARCH" = "ia64" ] ; then
		chown root:root $SBINDIR/parted2fdisk
	fi
fi

exit 0
