#!/usr/bin/perl -w
use Test::More 'no_plan';
use File::Temp qw/ tempdir /;
use File::Copy;
use MondoRescue::File;
use strict;

# Create the structure for the tests
my $bd = tempdir( 
	CLEANUP => 1 
	);

# Create directory structure
chdir $bd || die "Unable to chdir to $bd";
mkdir "usr",0755 || die "$!";
mkdir "usr/bin",0755 || die "$!";
mkdir "usr/lib",0755 || die "$!";
mkdir "var",0755 || die "$!";
mkdir "var/spool",0755 || die "$!";
mkdir "var/spool/mail",0755 || die "$!";
mkdir "var/lib",0755 || die "$!";

# Copy some files in it
copy "/usr/bin/perl","usr/bin" || die "$!";
chmod 0755,"usr/bin/perl";
my $libc;
foreach my $f (<"/lib/libc.so.[0-9]*">) {
	copy "$f","usr/lib" || die "$!";
	$libc = $f;
}

# Create links on files
chdir "$bd/usr/bin" || die "$!";
symlink "perl","toto" || die "$!";			# in same dir
chdir "$bd/var/spool/" || die "$!";
symlink "../../usr/bin/perl","toto" || die "$!";	# in another dir relatively
chdir "$bd/var" || die "$!";
symlink "$bd/usr/bin/perl","truc" || die "$!";		# in another dir absolutely

# Create links on dirs
chdir "$bd/var/spool" || die "$!";
symlink "mail","titi" || die "$!";			# in same dir
chdir "$bd/var/lib" || die "$!";
symlink "../spool/mail","titi" || die "$!";		# in another dir relatively
chdir "$bd/var" || die "$!";
symlink "$bd/var/spool/mail","tutu" || die "$!";		# in another dir absolutely

print "Temporary dir: $bd\n";

# Now try to see if we get the right links
my $h = mr_file_read_all_link(
	"$bd/usr/bin/toto",
	"$bd/var/spool/toto",
	"$bd/var/truc",
	"$bd/var/spool/titi",
	"$bd/var/lib/titi",
	"$bd/var/tutu"
	);

	# Got, expected, comment
is(@{$h->{"$bd/usr/bin/toto"}}[0], "$bd/usr/bin/toto", "File link in same dir to itself");
is(@{$h->{"$bd/usr/bin/toto"}}[1], "$bd/usr/bin/perl", "File link in same dir to link");
is(@{$h->{"$bd/var/truc"}}[0], "$bd/var/truc", "File link in another absolute dir to itself");
is(@{$h->{"$bd/var/truc"}}[1], "$bd/usr/bin/perl", "File link in another absolute dir to link");
is(@{$h->{"$bd/var/spool/toto"}}[0], "$bd/var/spool/toto", "File link in another relative dir to itself");
is(@{$h->{"$bd/var/spool/toto"}}[1], "$bd/usr/bin/perl", "File link in another relative dir to link");
is(@{$h->{"$bd/var/spool/titi"}}[0], "$bd/var/spool/titi", "Directory link in same dir to itself");
is(@{$h->{"$bd/var/spool/titi"}}[1], "$bd/var/spool/mail", "Directory link in same dir to link");
is(@{$h->{"$bd/var/lib/titi"}}[0], "$bd/var/lib/titi", "Directory link in another relative dir to itself");
is(@{$h->{"$bd/var/lib/titi"}}[1], "$bd/var/spool/mail", "Directory link in another relative dir to link");
is(@{$h->{"$bd/var/tutu"}}[0], "$bd/var/tutu", "Directory link in another absolute dir to itself");
is(@{$h->{"$bd/var/tutu"}}[1], "$bd/var/spool/mail", "Directory link in another absolute dir to link");
chdir "/tmp";
exit(0);
