#!/usr/bin/perl -w

use strict;
use POSIX "uname";
use Data::Dumper;

my ($sysname, $nodename, $release, $version, $machine ) = uname();
my $ver = "";
my $module = ""; 
my %modlist;
my $void = "";
my $allmodules = "";


if (not (defined $ARGV[0])) {
		$ver = $release;
} else {
		$ver = $ARGV[0];
}
open(LSMOD, "/sbin/lsmod |") or die "Unable to launch lsmod";
open(DEPMOD, "/sbin/depmod -n $ver |") or die "Unable to launch depmod";

while (<DEPMOD>) {
	($module, $modlist{$module}) = split(/:/);
	chomp($modlist{$module});
	last if ($module =~ /^#/);
	#print "Analyzing $module\n";
}
print Dumper(%modlist)."\n";
while (<LSMOD>) {
	next if (/^Module/);
	($module, $void) = split(/ /);
	#print "Analyzing $module\n";
	$module = `/sbin/modinfo -n $module`;
	chomp($module);
	my ($void,$lib,$modulep,$kernelv,$modpath) = split(/\//,$module,5);
	print "modpath: $modpath\n";
	$allmodules .= $modlist{$modpath};
}
close(LSMOD);
close(DEPMOD);
$allmodules =~ s/\n/ /g;
$allmodules =~ s/  */ /g;
$allmodules =~ s/ [0-9A-z\/]*\// /g;
$allmodules =~ s/\.ko.xz//g;
print "all modules: $allmodules\n";
