#!/bin/bash
#
# $Id: install.sh 3147 2013-06-19 06:34:46Z bruno $
#

if [ ! -f "mindi" ] ; then
    echo "Please 'cd' to the directory you have just untarred." >> /dev/stderr
    exit 1
fi

if [ "_$PREFIX" != "_" ]; then
	local=${HEAD}$PREFIX
	sublocal=$PREFIX
	if [ "_$CONFDIR" != "_" ]; then
		conf=${HEAD}$CONFDIR/mindi
		subconf=$CONFDIR/mindi
	else
		echo "CONFDIR should be defined if PREFIX is defined"
		exit -1
	fi
else
	local=/usr/local
	sublocal=$local
	if [ -f /usr/sbin/mindi ]; then
		echo "WARNING: /usr/sbin/mindi exists. You should probably remove the mindi package !"
	fi
	conf=$local/etc/mindi
	subconf=$conf
	echo $PATH | grep $local/sbin > /dev/null || echo "Warning - your PATH environmental variable is BROKEN. Please add $local/sbin to your PATH."
fi

if uname -a | grep Knoppix > /dev/null || [ -e "/ramdisk/usr" ] ; then
    local=/ramdisk/usr
	sublocal=$local
	conf=/ramdisk/etc
	subconf=$conf
    export PATH=/ramdisk/usr/sbin:/ramdisk/usr/bin:/$PATH
fi

MINDIVER=PBVER
MINDIREV=PBREV
VERSTR=${MINDIVER}-r${MINDIREV}
ARCH=`/bin/uname -m`
echo "mindi $VERSTR will be installed under $local"

if [ _"$MINDI_CACHE" = _"" ]; then
	localcache=$local/var/cache/mindi
else
	localcache=${HEAD}$MINDI_CACHE
fi
if [ _"$MANDIR" = _"" ]; then
	MANDIR=$local/share/man/man8
else
	MANDIR=${HEAD}$MANDIR/man8
fi
if [ _"$DOCDIR" = _"" ]; then
	DOCDIR=$local/share/doc/mindi-$MINDIVER
else
	DOCDIR=${HEAD}$DOCDIR/mindi-$MINDIVER
fi
if [ _"$DATADIR" = _"" ]; then
	localdata="$local/share"
	sublocaldata="$localdata/mindi"
else
	localdata=${HEAD}$DATADIR
	sublocaldata="$DATADIR/mindi"
fi

echo "Creating target directories ..."
install -m 755 -d $conf $localdata/mindi $MANDIR $local/sbin $localcache $conf/deplist.d

echo "Copying files ..."
cp -af rootfs $localdata/mindi
chmod 755 $localdata/mindi/rootfs/sbin/*
install -m 755 analyze-my-lvm $localdata/mindi
install -m 644 msg-txt dev.tgz $localdata/mindi
install -m 644 deplist.conf deplist-minimal.conf udev.files proliant.files mindi.conf $conf
for f in deplist.d/*.conf; do
	install -m 644 $f $conf/deplist.d
done

# Substitute variables for mindi
sed -e "s~^MINDI_PREFIX=XXX~MINDI_PREFIX=$sublocal~" -e "s~^MINDI_CONF=YYY~MINDI_CONF=$subconf~" -e "s~^MINDI_DATA=LLL~MINDI_DATA=$sublocaldata~" -e "s~^MINDI_CACHE=CCC~MINDI_CACHE=$MINDI_CACHE~" mindi > $local/sbin/mindi
sed -e "s~^MINDI_CONF=YYY~MINDI_CONF=$subconf~" -e "s~^export MINDI_CACHE=CCC~export MINDI_CACHE=$MINDI_CACHE~" rootfs/sbin/init > $localdata/mindi/rootfs/sbin/init
chmod 755 $local/sbin/mindi
install -m 644 mindi.8 $MANDIR
#install -m 644 ChangeLog COPYING README README.ia64 README.pxe TODO INSTALL svn.log $DOCDIR

# Manage perl script man pages
for s in mindi-bkphw mindi-get-perl-modules parted2fdisk.pl; do
	install -m 755 $s $local/sbin
	pod2man -c "$s a MondoRescue tool" --section=8 --release="$VERSTR" $local/sbin/$s > $s.8
	install -m 644 $s.8 $MANDIR
	# Generate the list of perl modules needed at restore time for mindi
	cat > $conf/perl-scripts << EOF
$sublocal/sbin/$s
EOF
done
(cd $MANDIR ; ln -s parted2fdisk.pl.8 parted2fdisk.9)

if [ "_$PREFIX" = "_" ] && [ ! -f $locallib/mindi/rootfs/bin/busybox ]; then
	echo "WARNING: no busybox found, mindi will not work on this arch ($ARCH)"
fi

# Managing parted2fdisk
if [ "$ARCH" = "ia64" ] ; then
	(cd $local/sbin && ln -sf parted2fdisk.pl parted2fdisk)
	install -s -m 755 $local/sbin/parted2fdisk.pl $localdata/mindi/rootfs/sbin/parted2fdisk
else
	# FHS requires fdisk under /sbin
	(cd $local/sbin && ln -sf ../../sbin/fdisk parted2fdisk)
	echo "Symlinking fdisk to parted2fdisk"
	( cd $localdata/mindi/rootfs/sbin && ln -sf fdisk parted2fdisk)
fi

if [ "$PKGBUILDMINDI" != "true" ]; then
	chown -R root:root $localdata/mindi $conf # $DOCDIR
	chown root:root $local/sbin/mindi $MANDIR/mindi.8 $localdata/mindi/analyze-my-lvm $local/sbin/parted2fdisk.pl 
	if [ "$ARCH" = "ia64" ] ; then
		chown root:root $local/sbin/parted2fdisk
	fi
fi

exit 0
