/*
 * $Id$
 *
 * Test program for mr_stresc
 * Can be used on host system with valgrind easier than with mondorestore
 */
#include <stdio.h>
#include <stdlib.h>
#include "mr_str.h"
#include "my-stuff.h"

/* Whether we should fail immediately at first error */
bool g_fail_immediately = FALSE;

void (*mr_cleanup)(void) = NULL;

char *strl[] = {
		"test with space",
		"test with \ backslash",
		"test with \" doublequote",
		"test with ' simplequote",
		"test with ~ tilde",
		"test with ? questionmark",
		"test with ! exclammark",
		"test with & ampersand",
		"test with * star",
		"test with | pipe",
};
// Number of strings
const int MAX = 10;

int main() {

		char *p;
		int i;

		for (i = 1; i <= MAX ; i++) {
				p = mr_stresc(strl[i], "`$\\\"(){}'[]&*?|!#~", '\\');
				printf("Original chain is %s\n",strl[i]);
				printf("Transformed chain is %s\n",p);
		}
exit(0);
}
