/***************************************************************************
$Id: mondorestore.c 2850 2011-07-24 02:12:44Z bruno $
restores mondoarchive data
The main file for mondorestore.
***************************************************************************/

/**************************************************************************
 * #include statements                                                    *
 **************************************************************************/
#include <pthread.h>
#include "my-stuff.h"
#include "mr_mem.h"
#include "../common/mondostructures.h"
#include "../common/libmondo.h"
#include "mr-externs.h"
#include "mondo-restore.h"
#include "mondorestore.h"
#include "mondo-rstr-compare-EXT.h"
#include "mondo-rstr-tools-EXT.h"

extern void twenty_seconds_til_yikes(void);

/* Let mr_cleanup pojnt to finish for the moment */
void (*mr_cleanup)(int) = finish;

/* Reference to global bkpinfo */
struct s_bkpinfo *bkpinfo;


/* For use in other programs (ex. XMondo) */
#ifdef MONDORESTORE_MODULE
#define main __mondorestore_main
#define g_ISO_restore_mode __mondorestore_g_ISO_restore_mode
#endif

//static char cvsid[] = "$Id: mondorestore.c 2850 2011-07-24 02:12:44Z bruno $";

/**************************************************************************
 * Globals                                                                *
 **************************************************************************/
/*
extern char *g_tmpfs_mountpt;	// declared in libmondo-tools.c
*/
extern bool g_text_mode;
extern FILE *g_fprep;
extern double g_kernel_version;
extern int g_partition_table_locked_up;
extern int g_noof_rows;

extern int partition_everything(struct mountlist_itself *mountlist);
extern int handle_incoming_parameters(int argc, char *argv[]);
extern int mount_media();

/**
 * @name Restore-Time Globals
 * @ingroup globalGroup
 * @{
 */

/**
 * If TRUE, then we're restoring from ISOs or an NFS server.
 * If FALSE, then we're restoring from some kind of real media (tape, CD, etc.)
 */
bool g_ISO_restore_mode = FALSE;	/* are we in Iso Mode? */

/**
 * If TRUE, then we have had a successful "nuke" restore.
 */
bool g_I_have_just_nuked = FALSE;

/**
 * The device to mount to get at the ISO images. Ignored unless @p g_ISO_restore_mode.
 */
char *g_isodir_device;

/**
 * The format of @p g_isodir_device. Ignored unless @p g_ISO_restore_mode.
 */
char *g_isodir_format;

/**
 * The location of 'filelist.full', containing all files (<em>including biggiefiles</em>) on
 * the current archive set.
 */
char *g_filelist_full;

/**
 * The location of a file containing a list of the devices that were archived
 * as images, not as individual files.
 */
char *g_filelist_imagedevs;

/**
 * The location of a file containing a list of imagedevs to actually restore.
 * @see g_filelist_imagedevs
 */
char *g_imagedevs_restthese;

/**
 * Mondo's home directory during backup. Unused in mondorestore; included
 * to avoid link errors.
 */
char *g_mondo_home;

extern char *g_getfacl;
extern char *g_getfattr;

/* @} - end of "Restore-Time Globals" in globalGroup */



extern int copy_from_src_to_dest(FILE * f_orig, FILE * f_archived,
								 char direction);



/**************************************************************************
 * COMPAQ PROLIANT Stuff:  needs some special help                        *
**************************************************************************/

/**
 * The message to display if we detect that the user is using a Compaq Proliant.
 */
#define COMPAQ_PROLIANTS_SUCK "Partition and format your disk using Compaq's disaster recovery CD. After you've done that, please reboot with your Mondo media in Interactive Mode."




/**
 * Allow the user to modify the mountlist before we partition & format their drives.
 * @param bkpinfo The backup information structure. @c disaster_recovery is the only field used.
 * @param mountlist The mountlist to let the user modify.
 * @param raidlist The raidlist that goes with @p mountlist.
 * @return 0 for success, nonzero for failure.
 * @ingroup restoreGuiGroup
 */
int let_user_edit_the_mountlist(struct mountlist_itself *mountlist,
								struct raidlist_itself *raidlist)
{
	int retval = 0, res = 0;

	log_msg(2, "let_user_edit_the_mountlist() --- starting");

	assert(bkpinfo != NULL);
	assert(mountlist != NULL);
	assert(raidlist != NULL);
	if (!does_file_exist(MINDI_CACHE"/mountlist.txt")) {
		log_to_screen(MINDI_CACHE"/mountlist.txt doesn't exist");
		return (1);
	}

	retval = load_mountlist(mountlist, MINDI_CACHE"/mountlist.txt");
	load_raidtab_into_raidlist(raidlist, RAIDTAB_FNAME);
	if (retval) {
		log_to_screen
			("Warning - load_raidtab_into_raidlist returned an error");
	}
	res = edit_mountlist(MINDI_CACHE"/mountlist.txt", mountlist, raidlist);
	if (res) {
		return (1);
	}

	save_mountlist_to_disk(mountlist, MINDI_CACHE"/mountlist.txt");
	save_raidlist_to_raidtab(raidlist, RAIDTAB_FNAME);

	log_to_screen("I have finished editing the mountlist for you.");

	return (retval);
}





/**
 * Determine whether @p mountlist contains a Compaq diagnostic partition.
 * @param mountlist The mountlist to examine.
 * @return TRUE if there's a Compaq diagnostic partition; FALSE if not.
 * @ingroup restoreUtilityGroup
 */
bool
partition_table_contains_Compaq_diagnostic_partition(struct
													 mountlist_itself *
													 mountlist)
{
	int i;

	assert(mountlist != NULL);

	for (i = 0; i < mountlist->entries; i++) {
		if (strstr(mountlist->el[i].format, "ompaq")) {
			log_msg(2, "mountlist[%d] (%s) is %s (Compaq alert!)",
					i, mountlist->el[i].device, mountlist->el[i].format);

			return (TRUE);
		}
	}
	return (FALSE);
}

/**************************************************************************
 *END_PARTITION_TABLE_CONTAINS_COMPAQ_DIAGNOSTIC_PARTITION                *
 **************************************************************************/


/**
 * Allow the user to abort the backup if we find that there is a Compaq diagnostic partition.
 * @note This function does not actually check for the presence of a Compaq partition.
 * @ingroup restoreUtilityGroup
 */
void offer_to_abort_because_Compaq_Proliants_suck(void)
{
	popup_and_OK(COMPAQ_PROLIANTS_SUCK);
	if (ask_me_yes_or_no
		("Would you like to reboot and use your Compaq CD to prep your hard drive?"))
	{
		fatal_error
			("Aborting. Please reboot and prep your hard drive with your Compaq CD.");
	}
}

/**************************************************************************
 *END_OFFER_TO_ABORT_BECAUSE_COMPAQ_PROLIANTS_SUCK                        *
 **************************************************************************/



/**
 * Call interactive_mode(), nuke_mode(), or compare_mode() depending on the user's choice.
 * @param bkpinfo The backup information structure. Most fields are used.
 * @param mountlist The mountlist containing information about the user's partitions.
 * @param raidlist The raidlist to go with @p mountlist.
 * @return The return code from the mode function called.
 * @ingroup restoreGroup
 */
int
catchall_mode(struct mountlist_itself *mountlist,
			  struct raidlist_itself *raidlist)
{
	char c;
	char *tmp = NULL;
	int retval = 0;

	log_it("inside catchall");
	assert(bkpinfo != NULL);
	assert(mountlist != NULL);
	assert(raidlist != NULL);
	log_it("pre wrm");
	c = which_restore_mode();
	log_it("post wrm");
	if (c == 'I' || c == 'C') {
		interactively_obtain_media_parameters_from_user(FALSE);
	} else if (c == 'N') {
		// Auto mode nothing special to do
	} else {
		popup_and_OK("No restoring or comparing will take place today.");
		if (is_this_device_mounted("/mnt/cdrom")) {
			run_program_and_log_output("umount /mnt/cdrom", FALSE);
		}
		if (g_ISO_restore_mode) {
			mr_asprintf(tmp, "umount %s", bkpinfo->isodir);
			run_program_and_log_output(tmp, FALSE);
			mr_free(tmp);
		}
		paranoid_MR_finish(0);
	}

	log_it("post int");

	if (bkpinfo->backup_media_type == iso) {
		if (iso_fiddly_bits((c == 'N') ? TRUE : FALSE)) {
			log_msg(2,
					"catchall_mode --- iso_fiddly_bits returned w/ error");
			return (1);
		} else {
			log_msg(2, "catchall_mode --- iso_fiddly_bits ok");
		}
	}

	if (c == 'I') {
		log_msg(2, "IM selected");
		retval += interactive_mode(mountlist, raidlist);
	} else if (c == 'N') {
		log_msg(2, "NM selected");
		retval += nuke_mode(mountlist, raidlist);
	} else if (c == 'C') {
		log_msg(2, "CM selected");
		retval += compare_mode(mountlist, raidlist);
	}
	return (retval);
}

/**************************************************************************
 *END_CATCHALL_MODE                                                      *
 **************************************************************************/

/**************************************************************************
 *END_  EXTRACT_CONFIG_FILE_FROM_RAMDISK                                  *
 **************************************************************************/


/**
 * Locate an executable in the directory structure rooted at @p restg.
 * @param out_path Where to put the executable.
 * @param fname The basename of the executable.
 * @param restg The directory structure to look in.
 * @note If it could not be found in @p restg then @p fname is put in @p out_path.
 * @ingroup restoreUtilityGroup
 */
void
find_pathname_of_executable_preferably_in_RESTORING(char *out_path,
													char *fname,
													char *restg)
{
	assert(out_path != NULL);
	assert_string_is_neither_NULL_nor_zerolength(fname);

	sprintf(out_path, "%s/sbin/%s", restg, fname);
	if (does_file_exist(out_path)) {
		sprintf(out_path, "%s/usr/sbin/%s", restg, fname);
		if (does_file_exist(out_path)) {
			sprintf(out_path, "%s/bin/%s", restg, fname);
			if (does_file_exist(out_path)) {
				sprintf(out_path, "%s/usr/bin/%s", restg, fname);
				if (does_file_exist(out_path)) {
					strcpy(out_path, fname);
				}
			}
		}
	}
}

/**************************************************************************
 *END_FIND_PATHNAME_OF_EXECUTABLE_PREFERABLY_IN_RESTORING                 *
 **************************************************************************/

static void clean_blkid() {

	char *tmp1 = NULL;

	if (bkpinfo->restore_path) {
		/* Clean up blkid cache file if they exist */
		mr_asprintf(tmp1,"%s/etc/blkid.tab",bkpinfo->restore_path);
		(void)unlink(tmp1);
		paranoid_free(tmp1);
		mr_asprintf(tmp1,"%s/etc/blkid.tab.old",bkpinfo->restore_path);
		(void)unlink(tmp1);
		paranoid_free(tmp1);
	}
}


static void clean_multipathconf() {

	char *tmp1 = NULL;
	char *editor = NULL;

	if (bkpinfo->restore_path) {
		/* Clean up multiconf cache file if they exist */
		mr_asprintf(tmp1,"%s/var/lib/multipath/bindings",bkpinfo->restore_path);
		(void)unlink(tmp1);
		paranoid_free(tmp1);
	}

	/* Edit multipath.conf if needed to adapt wwid */
	mr_asprintf(tmp1,"%s/etc/multipath.conf", MNT_RESTORING);
	if (does_file_exist(tmp1)) {
		log_msg(2, "We may need to clean /etc/multipath.conf");
	} else {
		paranoid_free(tmp1);
		return;
	}
	paranoid_free(tmp1);

	if (bkpinfo->restore_mode != nuke) {
		mr_asprintf(editor, "%s", find_my_editor());
		mr_asprintf(tmp1,"chroot %s %s /etc/multipath.conf", MNT_RESTORING, editor);
		popup_and_OK("You will now edit multipath.conf");
		if (!g_text_mode) {
			newtSuspend();
		}
		paranoid_system(tmp1);
		if (!g_text_mode) {
			newtResume();
		}
		paranoid_free(tmp1);
		paranoid_free(editor);
	} else {
		log_to_screen("Non-interactive mode: no way to give you the keyboard so that you edit your multipath.conf. Hope it's OK");
		log_msg(1,"Non-interactive mode: no way to give you the keyboard so that you edit your multipath.conf. Hope it's OK");
	}
}




/**
 * @addtogroup restoreGroup
 * @{
 */
/**
 * Restore the user's data, in a disaster recovery situation, prompting the
 * user about whether or not to do every step.
 * The user can edit the mountlist, choose files to restore, etc.
 * @param bkpinfo The backup information structure. Most fields are used.
 * @param mountlist The mountlist containing information about the user's partitions.
 * @param raidlist The raidlist to go with @p mountlist.
 * @return 0 for success, or the number of errors encountered.
 */
int interactive_mode(struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
	int retval = 0;
	int res;
	int ptn_errs = 0;
	int fmt_errs = 0;

	bool done;
	bool restore_all;

  /** needs malloc **********/
	char *tmp;
	char *p = NULL;
	char *tmp1 = NULL;
	char *fstab_fname = NULL;
	char *old_restpath = NULL;

	struct s_node *filelist;

	/* try to partition and format */

	log_msg(2, "interactive_mode --- starting (great, assertions OK)");

	malloc_string(tmp);
	assert(bkpinfo != NULL);
	assert(mountlist != NULL);
	assert(raidlist != NULL);

	log_msg(2, "interactive_mode --- assertions OK");

	if (g_text_mode) {
		if (!ask_me_yes_or_no("Interactive Mode + textonly = experimental! Proceed anyway?")) {
			fatal_error("Wise move.");
		}
	}

	log_it("About to load config file");
	read_cfg_file_into_bkpinfo(MINDI_CACHE"/mondorestore.cfg");
	log_it("Done loading config file; resizing ML");

	tmp1 = call_program_and_get_last_line_of_output("cat " CMDLINE,TRUE);
	if (strstr(tmp1, "noresize")) {
		log_msg(1, "Not resizing mountlist.");
	} else {
		resize_mountlist_proportionately_to_suit_new_drives(mountlist);
	}
	mr_free(tmp1);

	for (done = FALSE; !done;) {
		log_it("About to edit mountlist");
		if (g_text_mode) {
			save_mountlist_to_disk(mountlist, MINDI_CACHE"/mountlist.txt");
			mr_asprintf(tmp1, "%s %s", find_my_editor(), MINDI_CACHE"/mountlist.txt");
			res = system(tmp1);
			mr_free(tmp1);
			load_mountlist(mountlist, MINDI_CACHE"/mountlist.txt");
		} else {
			res = edit_mountlist(MINDI_CACHE"/mountlist.txt", mountlist, raidlist);
		}
		log_it("Finished editing mountlist");
		if (res) {
			paranoid_MR_finish(1);
		}
		log_msg(2, "Proceeding...");
		save_mountlist_to_disk(mountlist, MINDI_CACHE"/mountlist.txt");
		save_raidlist_to_raidtab(raidlist, RAIDTAB_FNAME);
		mvaddstr_and_log_it(1, 30, "Restoring Interactively");
		if (bkpinfo->differential) {
			log_to_screen("Because this is a differential backup, disk");
			log_to_screen
				(" partitioning and formatting will not take place.");
			done = TRUE;
		} else {
			if (ask_me_yes_or_no
				("Do you want to erase and partition your hard drives?")) {
				if (partition_table_contains_Compaq_diagnostic_partition
					(mountlist)) {
					offer_to_abort_because_Compaq_Proliants_suck();
					done = TRUE;
				} else {
					twenty_seconds_til_yikes();
					g_fprep = fopen("/tmp/prep.sh", "w");
					ptn_errs = partition_everything(mountlist);
					if (ptn_errs) {
						log_to_screen
							("Warning. Errors occurred during disk partitioning.");
					}

					fmt_errs = format_everything(mountlist, FALSE, raidlist);
					if (!fmt_errs) {
						log_to_screen
							("Errors during disk partitioning were handled OK.");
						log_to_screen
							("Partitions were formatted OK despite those errors.");
						ptn_errs = 0;
					}
					if (!ptn_errs && !fmt_errs) {
						done = TRUE;
					}
				}
				paranoid_fclose(g_fprep);
			} else {
				mvaddstr_and_log_it(g_currentY++, 0,
									"User opted not to partition the devices");
				if (ask_me_yes_or_no
					("Do you want to format your hard drives?")) {
					fmt_errs = format_everything(mountlist, TRUE, raidlist);
					if (!fmt_errs) {
						done = TRUE;
					}
				} else {
					ptn_errs = fmt_errs = 0;
					done = TRUE;
				}
			}
			if (fmt_errs) {
				mvaddstr_and_log_it(g_currentY++,
									0,
									"Errors occurred. Please repartition and format drives manually.");
				done = FALSE;
			}
			if (ptn_errs & !fmt_errs) {
				mvaddstr_and_log_it(g_currentY++,
									0,
									"Errors occurred during partitioning. Formatting, however, went OK.");
				done = TRUE;
			}
			if (!done) {
				if (!ask_me_yes_or_no("Re-edit the mountlist?")) {
					retval++;
					goto end_of_func;
				}
			}
		}
	}

	/* mount */
	if (mount_all_devices(mountlist, TRUE)) {
		unmount_all_devices(mountlist);
		retval++;
		goto end_of_func;
	}
	/* restore */
	if ((restore_all = ask_me_yes_or_no("Do you want me to restore all of your data?"))) {
		log_msg(1, "Restoring all data");
		retval += restore_everything(NULL);
	} else if ((restore_all = ask_me_yes_or_no("Do you want me to restore _some_ of your data?"))) {
		mr_asprintf(old_restpath, "%s", bkpinfo->restore_path);
		for (done = FALSE; !done;) {
			unlink("/tmp/filelist.full");
			filelist = process_filelist_and_biggielist();
			/* Now you have /tmp/tmpfs/filelist.restore-these and /tmp/tmpfs/biggielist.restore-these;
			   the former is a list of regular files; the latter, biggiefiles and imagedevs.
			 */
			if (filelist) {
			  gotos_suck:
				strcpy(tmp, old_restpath);
				// (NB: %s is where your filesystem is mounted now, by default)", MNT_RESTORING);
				p = popup_and_get_string("Restore path", "Restore files to where?", tmp);
				if (p != NULL) {
					strcpy(tmp, p);
					if (!strcmp(tmp, "/")) {
						if (!ask_me_yes_or_no("Are you sure?")) {
							goto gotos_suck;
						}
						tmp[0] = '\0';	// so we restore to [blank]/file/name :)
					}
					mr_free(bkpinfo->restore_path);
					mr_asprintf(bkpinfo->restore_path, "%s", tmp);
					log_msg(1, "Restoring subset");
					retval += restore_everything(filelist);
				} else {
					mr_free(bkpinfo->restore_path);
					mr_asprintf(bkpinfo->restore_path, "%s", old_restpath);
				}
				free_filelist(filelist);
				mr_free(p);

				if (!ask_me_yes_or_no("Restore another subset of your backup?")) {
					done = TRUE;
				}
			} else {
				done = TRUE;
			}
		}
		mr_free(old_restpath);
	} else {
		mvaddstr_and_log_it(g_currentY++, 0, "User opted not to restore any data.                                  ");
	}
	if (retval) {
		mvaddstr_and_log_it(g_currentY++, 0, "Errors occurred during the restore phase.            ");
	}

	clean_multipathconf();
	if (ask_me_yes_or_no("Initialize the boot loader?")) {
		run_boot_loader(TRUE);
	} else {
		mvaddstr_and_log_it(g_currentY++,
							0,
							"User opted not to initialize the boot loader.");
	}

	clean_blkid();
	protect_against_braindead_sysadmins();
	retval += unmount_all_devices(mountlist);

	/*  if (restore_some || restore_all || */
	if (ask_me_yes_or_no
		("Label/Identify your ext2/ext3/ext4 partitions if necessary?")) {
		mvaddstr_and_log_it(g_currentY, 0,
							"Using tune2fs to identify your ext2,3,4 partitions");
		if (does_file_exist("/tmp/fstab.new")) {
			mr_asprintf(fstab_fname, "/tmp/fstab.new");
		} else {
			mr_asprintf(fstab_fname, "/tmp/fstab");
		}
		mr_asprintf(tmp1, "label-partitions-as-necessary %s < %s >> %s 2>> %s", MINDI_CACHE"/mountlist.txt", fstab_fname, MONDO_LOGFILE, MONDO_LOGFILE);
		mr_free(fstab_fname);

		res = system(tmp1);
		mr_free(tmp1);
		if (res) {
			log_to_screen
				("label-partitions-as-necessary returned an error");
			mvaddstr_and_log_it(g_currentY++, 74, "Failed.");
		} else {
			mvaddstr_and_log_it(g_currentY++, 74, "Done.");
		}
		retval += res;
	}

	log_it("About to leave interactive_mode()");
	if (retval) {
		mvaddstr_and_log_it(g_currentY++,
							0,
							"Warning - errors occurred during the restore phase.");
	}
  end_of_func:
	paranoid_free(tmp);
	log_it("Leaving interactive_mode()");
	return (retval);
}

/**************************************************************************
 *END_INTERACTIVE_MODE                                                    *
 **************************************************************************/



/**
 * Run an arbitrary restore mode (prompt the user), but from ISO images
 * instead of real media.
 * @param mountlist The mountlist containing information about the user's partitions.
 * @param raidlist The raidlist that goes with @p mountlist.
 * @param nuke_me_please If TRUE, we plan to run Nuke Mode.
 * @return 0 for success, or the number of errors encountered.
 */
int
iso_mode(struct mountlist_itself *mountlist,
		 struct raidlist_itself *raidlist, bool nuke_me_please)
{
	char c;
	int retval = 0;

	assert(mountlist != NULL);
	assert(raidlist != NULL);
	if (iso_fiddly_bits(nuke_me_please)) {
		log_msg(1, "iso_mode --- returning w/ error");
		return (1);
	} else {
		c = which_restore_mode();
		if (c == 'I' || c == 'N' || c == 'C') {
			interactively_obtain_media_parameters_from_user(FALSE);
		}
		if (c == 'I') {
			retval += interactive_mode(mountlist, raidlist);
		} else if (c == 'N') {
			retval += nuke_mode(mountlist, raidlist);
		} else if (c == 'C') {
			retval += compare_mode(mountlist, raidlist);
		} else {
			log_to_screen("OK, I shan't restore/compare any files.");
		}
	}
	if (is_this_device_mounted(MNT_CDROM)) {
		paranoid_system("umount " MNT_CDROM);
	}
//  if (! already_mounted)
//    {
	if (system("umount /tmp/isodir 2> /dev/null")) {
		log_to_screen
			("WARNING - unable to unmount device where the ISO files are stored.");
	}
//    }
	return (retval);
}

/**************************************************************************
 *END_ISO_MODE                                                            *
 **************************************************************************/


/*            MONDO - saving your a$$ since Feb 18th, 2000            */




/**
 * Restore the user's data automatically (no prompts), after a twenty-second
 * warning period.
 * @param bkpinfo The backup information structure. Most fields are used.
 * @param mountlist The mountlist containing information about the user's partitions.
 * @param raidlist The raidlist that goes with @p mountlist.
 * @return 0 for success, or the number of errors encountered.
 * @warning <b><i>THIS WILL ERASE ALL EXISTING DATA!</i></b>
 */
int
nuke_mode(struct mountlist_itself *mountlist,
		  struct raidlist_itself *raidlist)
{
	int retval = 0;
	int res = 0;
	bool boot_loader_installed = FALSE;
	char *tmp = NULL;
	char *tmp1 = NULL;
	char *flaws_str = NULL;

	assert(bkpinfo != NULL);
	assert(mountlist != NULL);
	assert(raidlist != NULL);

	log_msg(2, "nuke_mode --- starting");
	load_mountlist(mountlist, MINDI_CACHE"/mountlist.txt");	// in case read_cfg_file_into_bkpinfo updated the mountlist

	tmp = call_program_and_get_last_line_of_output("cat " CMDLINE,TRUE);
	if (strstr(tmp, "noresize")) {
		log_msg(2, "Not resizing mountlist.");
	} else {
		resize_mountlist_proportionately_to_suit_new_drives(mountlist);
	}
	mr_free(tmp);

	flaws_str = evaluate_mountlist(mountlist);
	if (flaws_str != NULL) {
		mr_asprintf(tmp, "Mountlist analyzed. Result: \"%s\" Switch to Interactive Mode?", flaws_str);
		mr_free(flaws_str);
		res = ask_me_yes_or_no(tmp);
		mr_free(tmp);
		if (res) {
			retval = interactive_mode(mountlist, raidlist);
			goto after_the_nuke;
		} else {
			fatal_error("Nuke Mode aborted. ");
		}
	}

	save_mountlist_to_disk(mountlist, MINDI_CACHE"/mountlist.txt");
	mvaddstr_and_log_it(1, 30, "Restoring Automatically");
	if (bkpinfo->differential) {
		log_to_screen("Because this is a differential backup, disk");
		log_to_screen("partitioning and formatting will not take place.");
		res = 0;
	} else {
		if (partition_table_contains_Compaq_diagnostic_partition
			(mountlist)) {
			offer_to_abort_because_Compaq_Proliants_suck();
		} else {
			twenty_seconds_til_yikes();
			g_fprep = fopen("/tmp/prep.sh", "w");
			tmp = call_program_and_get_last_line_of_output("cat " CMDLINE,TRUE);
			if (strstr(tmp, "nopart")) {
				log_msg(2, "Not partitioning drives due to 'nopart' option.");
				res = 0;
			} else {
				res = partition_everything(mountlist);
				if (res) {
					log_to_screen("Warning. Errors occurred during partitioning.");
					res = 0;
				}
			}
			mr_free(tmp);

			retval += res;
			if (!res) {
				log_to_screen("Preparing to format your disk(s)");
				sleep(1);
				sync();
				log_to_screen("Please wait. This may take a few minutes.");
				res += format_everything(mountlist, FALSE, raidlist);
			}
			paranoid_fclose(g_fprep);
		}
	}
	retval += res;
	if (res) {
		mvaddstr_and_log_it(g_currentY++,
							0,
							"Failed to partition and/or format your hard drives.");

		if (ask_me_yes_or_no("Try in interactive mode instead?")) {
			retval = interactive_mode(mountlist, raidlist);
			goto after_the_nuke;
		} else
			if (!ask_me_yes_or_no
				("Would you like to try to proceed anyway?")) {
			return (retval);
		}
	}
	retval = mount_all_devices(mountlist, TRUE);
	if (retval) {
		unmount_all_devices(mountlist);
		log_to_screen
			("Unable to mount all partitions. Sorry, I cannot proceed.");
		return (retval);
	}
	log_it("Restoring everything");
	retval += restore_everything(NULL);
	clean_multipathconf();
	if (!run_boot_loader(FALSE)) {
		log_msg(1,
				"Great! Boot loader was installed. No need for msg at end.");
		boot_loader_installed = TRUE;
	}
	clean_blkid();
	protect_against_braindead_sysadmins();
	retval += unmount_all_devices(mountlist);
	mvaddstr_and_log_it(g_currentY,
						0,
						"Using tune2fs to identify your ext2,3 partitions");

	mr_asprintf(tmp, "label-partitions-as-necessary %s < /tmp/fstab >> %s 2>> %s", g_mountlist_fname, MONDO_LOGFILE, MONDO_LOGFILE);
	res = run_program_and_log_output(tmp, TRUE);
	mr_free(tmp);
	if (res) {
		log_to_screen("label-partitions-as-necessary returned an error");
		mvaddstr_and_log_it(g_currentY++, 74, "Failed.");
	} else {
		mvaddstr_and_log_it(g_currentY++, 74, "Done.");
	}
	retval += res;

  after_the_nuke:
	tmp1 = call_program_and_get_last_line_of_output("cat " CMDLINE,TRUE);
	if (retval) {
		log_to_screen("Errors occurred during the nuke phase.");
	} else if (strstr(tmp1, "RESTORE")) {
		log_to_screen("PC was restored successfully. Thank you for using Mondo Rescue.");
		log_to_screen("Please visit our website at http://www.mondorescue.org for more information.");
	} else {
		mr_asprintf(tmp,"%s","Mondo has restored your system.\n\nPlease wait for the command prompt. Then remove the backup media and reboot.\n\nPlease visit our website at http://www.mondorescue.org for more information.");
		popup_and_OK(tmp);
		mr_free(tmp);
		log_to_screen("Mondo has restored your system. Please wait for the command prompt.");
		log_to_screen("Then remove the backup media and reboot.");
		log_to_screen("Please visit our website at http://www.mondorescue.org for more information.");
	}
	mr_free(tmp1);

	g_I_have_just_nuked = TRUE;
	return (retval);
}

/**************************************************************************
 *END_NUKE_MODE                                                           *
 **************************************************************************/



/**
 * Restore the user's data (or a subset of it) to the live filesystem.
 * This should not be called if we're booted from CD!
 * @param bkpinfo The backup information structure. Most fields are used.
 * @return 0 for success, or the number of errors encountered.
 */
int restore_to_live_filesystem()
{
	int retval = 0;

	char *old_restpath = NULL;
	char *p = NULL;

	struct mountlist_itself *mountlist = NULL;
	struct raidlist_itself *raidlist = NULL;
	struct s_node *filelist = NULL;

	log_msg(1, "restore_to_live_filesystem() - starting");
	assert(bkpinfo != NULL);
	mountlist = malloc(sizeof(struct mountlist_itself));
	raidlist = malloc(sizeof(struct raidlist_itself));
	if (!mountlist || !raidlist) {
		fatal_error("Cannot malloc() mountlist and/or raidlist");
	}

	mr_free(bkpinfo->restore_path);
	mr_asprintf(bkpinfo->restore_path, "/");
	if (bkpinfo->backup_media_type != netfs) {
		popup_and_OK
			("Please insert tape/CD/USB Key, then hit 'OK' to continue.");
		sleep(1);
		interactively_obtain_media_parameters_from_user(FALSE);
	}
	if (!bkpinfo->media_device) {
		log_msg(2, "WARNING: failed to find media dev");
	} else {
		log_msg(2, "bkpinfo->media_device = %s", bkpinfo->media_device);
	}


	log_msg(2, "bkpinfo->isodir = %s", bkpinfo->isodir);

	open_evalcall_form("Thinking...");
	read_cfg_file_into_bkpinfo(MINDI_CACHE"/mondorestore.cfg");
	load_mountlist(mountlist, MINDI_CACHE"/mountlist.txt");	// in case read_cfg_file_into_bkpinfo 

	close_evalcall_form();
	retval = load_mountlist(mountlist, MINDI_CACHE"/mountlist.txt");
	load_raidtab_into_raidlist(raidlist, RAIDTAB_FNAME);

	if ((bkpinfo->backup_media_type != netfs) && (filelist = process_filelist_and_biggielist())) {
		save_filelist(filelist, "/tmp/selected-files.txt");
		mr_asprintf(old_restpath, "%s", bkpinfo->restore_path);
		p = popup_and_get_string("Restore path", "Restore files to where? )", bkpinfo->restore_path);
		if (p != NULL) {
			mr_free(bkpinfo->restore_path);
			bkpinfo->restore_path = p;

			log_it("Restoring everything");
			retval += restore_everything(filelist);
		}
		free_filelist(filelist);
		mr_free(bkpinfo->restore_path);
		bkpinfo->restore_path = old_restpath;
	} else {
		if (filelist != NULL) {
			retval += restore_everything(NULL);
		}
	}
	if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type)) {
		log_msg(2,
				"Tape : I don't need to unmount or eject the CD-ROM.");
	} else {
		run_program_and_log_output("umount " MNT_CDROM, FALSE);
		if (!bkpinfo->please_dont_eject) {
			eject_device(bkpinfo->media_device);
		}
	}
	run_program_and_log_output("umount " MNT_CDROM, FALSE);
	if (!bkpinfo->please_dont_eject) {
		eject_device(bkpinfo->media_device);
	}
	free(mountlist);
	free(raidlist);
	return (retval);
}

/**************************************************************************
 *END_RESTORE_TO_LIVE_FILESYSTEM                                          *
 **************************************************************************/

/* @} - end of restoreGroup */


#include <utime.h>
/**
 * @addtogroup LLrestoreGroup
 * @{
 */
/**
 * Restore biggiefile @p bigfileno from the currently mounted CD.
 * @param bkpinfo The backup information structure. Fields used:
 * - @c bkpinfo->backup_media_type
 * - @c bkpinfo->restore_path
 * @param bigfileno The biggiefile number (starting from 0) to restore.
 * @param filelist The node structure containing the list of files to restore.
 * If the biggiefile is not in this list, it will be skipped (return value will
 * still indicate success).
 * @return 0 for success (or skip), nonzero for failure.
 */
int
restore_a_biggiefile_from_CD(long bigfileno,
							 struct s_node *filelist,
							 char *pathname_of_last_file_restored)
{
	FILE *fin;
	FILE *fout;
	FILE *fbzip2;

  /** malloc ***/
	char *checksum = NULL;
	char *outfile_fname = NULL;
	char *tmp = NULL;
	char *bzip2_command = NULL;
	char *suffix = NULL;
	char *sz_devfile = NULL;
	char *bigblk;
	char *mds = NULL;
	int retval = 0;
	int finished = FALSE;
	long sliceno;
	long siz;
	char *ntfsprog_fifo = NULL;
	char *file_to_openout = NULL;
	struct s_filename_and_lstat_info biggiestruct;
	struct utimbuf the_utime_buf, *ubuf;
	bool use_ntfsprog_hack = FALSE;
	pid_t pid;
	int res = 0;
	int old_loglevel;
	struct s_node *node;

	old_loglevel = g_loglevel;
	ubuf = &the_utime_buf;
	assert(bkpinfo != NULL);

	pathname_of_last_file_restored[0] = '\0';
	if (!(bigblk = malloc(TAPE_BLOCK_SIZE))) {
		fatal_error("Cannot malloc bigblk");
	}

	if (!(fin = fopen(slice_fname(bigfileno, 0, ARCHIVES_PATH, ""), "r"))) {
		log_to_screen("Cannot even open bigfile's info file");
		return (1);
	}

	memset((void *) &biggiestruct, 0, sizeof(biggiestruct));
	if (fread((void *) &biggiestruct, 1, sizeof(biggiestruct), fin) <
		sizeof(biggiestruct)) {
		log_msg(2, "Warning - unable to get biggiestruct of bigfile #%d",
				bigfileno + 1);
	}
	paranoid_fclose(fin);

	mr_asprintf(checksum, "%s", biggiestruct.checksum);
	if (!checksum[0]) {
		log_msg(3, "Warning - bigfile %ld does not have a checksum", bigfileno + 1);
	}
	mr_free(checksum);

	if (!strncmp(biggiestruct.filename, "/dev/", 5))	// Whether NTFS or not :)
	{
		mr_asprintf(outfile_fname, "%s", biggiestruct.filename);
	} else {
		mr_asprintf(outfile_fname, "%s/%s", bkpinfo->restore_path, biggiestruct.filename);
	}

	/* skip file if we have a selective restore subset & it doesn't match */
	if (filelist != NULL) {
		node = find_string_at_node(filelist, biggiestruct.filename);
		if (!node) {
			log_msg(0, "Skipping %s (name isn't in filelist)", biggiestruct.filename);
			pathname_of_last_file_restored[0] = '\0';
			return (0);
		} else if (!(node->selected)) {
			log_msg(1, "Skipping %s (name isn't in biggielist subset)", biggiestruct.filename);
			pathname_of_last_file_restored[0] = '\0';
			return (0);
		}
	}

	/* otherwise, continue */
	log_msg(1, "DEFINITELY restoring %s", biggiestruct.filename);
	if (biggiestruct.use_ntfsprog) {
		if (strncmp(biggiestruct.filename, "/dev/", 5)) {
			log_msg(1, "I was in error when I set biggiestruct.use_ntfsprog to TRUE.");
			log_msg(1, "%s isn't even in /dev", biggiestruct.filename);
			biggiestruct.use_ntfsprog = FALSE;
		}
	}

	if (biggiestruct.use_ntfsprog)	// if it's an NTFS device
	{
		g_loglevel = 4;
		use_ntfsprog_hack = TRUE;
		log_msg(2, "Calling ntfsclone in background because %s is an NTFS /dev entry", outfile_fname);
		mr_asprintf(sz_devfile, "/tmp/%d.%d.000", (int) (random() % 32768), (int) (random() % 32768));
		mkfifo(sz_devfile, 0x770);
		mr_asprintf(ntfsprog_fifo, "%s", sz_devfile);
		mr_free(sz_devfile);
		file_to_openout = ntfsprog_fifo;
		switch (pid = fork()) {
		case -1:
			fatal_error("Fork failure");
		case 0:
			log_msg(3, "CHILD - fip - calling feed_outfrom_ntfsprog(%s, %s)", biggiestruct.filename, ntfsprog_fifo);
			res = feed_outfrom_ntfsprog(biggiestruct.filename, ntfsprog_fifo);
			mr_free(ntfsprog_fifo);
			exit(res);
			break;
		default:
			log_msg(3, "feed_into_ntfsprog() called in background --- pid=%ld", (long int) (pid));
		}
		mr_free(ntfsprog_fifo);
	} else {
		use_ntfsprog_hack = FALSE;
		file_to_openout = outfile_fname;
		if (!does_file_exist(outfile_fname))	// yes, it looks weird with the '!' but it's correct that way
		{
			make_hole_for_file(outfile_fname);
		}
	}

	log_msg(2, "Reassembling big file %ld (%s)", bigfileno + 1, outfile_fname);

	/*
	   last slice is zero-length and uncompressed; when we find it, we stop.
	   We DON'T wait until there are no more slices; if we did that,
	   We might stop at end of CD, not at last slice (which is 0-len and uncompd)
	 */

	strncpy(pathname_of_last_file_restored, biggiestruct.filename, MAX_STR_LEN - 1);
	pathname_of_last_file_restored[MAX_STR_LEN - 1] = '\0';

	log_msg(3, "file_to_openout = %s", file_to_openout);
	if (!(fout = fopen(file_to_openout, "w"))) {
		log_to_screen("Cannot openout outfile_fname - hard disk full?");
		return (1);
	}
	log_msg(3, "Opened out to %s", outfile_fname);	// CD/DVD --> mondorestore --> ntfsclone --> hard disk itself

	for (sliceno = 1, finished = FALSE; !finished;) {
		if (!does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "")) &&
			!does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "lzo")) &&
			!does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "gz")) &&
			!does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "lzma")) &&
			!does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "bz2"))) {
			log_msg(3, "Cannot find a data slice or terminator slice on CD %d", g_current_media_number);
			g_current_media_number++;
			mds = media_descriptor_string(bkpinfo->backup_media_type);
			log_msg(2, "Asking for %s #%d so that I may read slice #%ld\n", mds, g_current_media_number, sliceno);
			mr_free(mds);

			log_to_screen("Restoring from %s #%d", mds, g_current_media_number);

			insist_on_this_cd_number(g_current_media_number);
			log_to_screen("Continuing to restore.");
		} else {
			mr_asprintf(tmp, "%s", slice_fname(bigfileno, sliceno, ARCHIVES_PATH, ""));
			if (does_file_exist(tmp) && length_of_file(tmp) == 0) {
				log_msg(2, "End of bigfile # %ld (slice %ld is the terminator)", bigfileno + 1, sliceno);
				finished = TRUE;
				mr_free(tmp);
				continue;
			} else {
				if (does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "lzo"))) {
					mr_asprintf(bzip2_command, "lzop");
					mr_asprintf(suffix, "lzo");
				} else
					if (does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "gz"))) {
					mr_asprintf(bzip2_command, "gzip");
					mr_asprintf(suffix, "gz");
				} else
					if (does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "lzma"))) {
					mr_asprintf(bzip2_command, "lzma");
					mr_asprintf(suffix, "lzma");
				} else
					if (does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, "bz2"))) {
					mr_asprintf(bzip2_command, "bzip2");
					mr_asprintf(suffix, "bz2");
				} else
					if (does_file_exist(slice_fname(bigfileno, sliceno, ARCHIVES_PATH, ""))) {
					mr_asprintf(bzip2_command, "");
					mr_asprintf(suffix, "");
				} else {
					log_to_screen("OK, that's pretty fsck0red...");
					mr_free(tmp);
					return (1);
				}
			}
			mr_free(tmp);
			if (bzip2_command != NULL) {
				mr_strcat(bzip2_command, " -dc %s 2>> %s", slice_fname(bigfileno, sliceno, ARCHIVES_PATH, suffix), MONDO_LOGFILE);
			} else {
				mr_asprintf(bzip2_command, "cat %s 2>> %s", slice_fname(bigfileno, sliceno, ARCHIVES_PATH, suffix), MONDO_LOGFILE);
			}
			mr_free(suffix);

			mds = media_descriptor_string(bkpinfo->backup_media_type);
			mr_asprintf(tmp, "Working on %s #%d, file #%ld, slice #%ld    ", mds, g_current_media_number, bigfileno + 1, sliceno);
			mr_free(mds);
			log_msg(2, tmp);

			if (!g_text_mode) {
				newtDrawRootText(0, g_noof_rows - 2, tmp);
				newtRefresh();
				strip_spaces(tmp);
				update_progress_form(tmp);
			}
			mr_free(tmp);

			if (!(fbzip2 = popen(bzip2_command, "r"))) {
				fatal_error("Can't run popen command");
			}
			mr_free(bzip2_command);

			while (!feof(fbzip2)) {
				siz = fread(bigblk, 1, TAPE_BLOCK_SIZE, fbzip2);
				if (siz > 0) {
					siz = fwrite(bigblk, 1, siz, fout);
				}
			}
			paranoid_pclose(fbzip2);


			sliceno++;
			g_current_progress++;
		}
	}
	paranoid_fclose(fout);
	g_loglevel = old_loglevel;

	if (use_ntfsprog_hack) {
		log_msg(3, "Waiting for ntfsclone to finish");
		mr_asprintf(tmp, " ps | grep \" ntfsclone \" | grep -v grep > /dev/null 2> /dev/null");
		while (system(tmp) == 0) {
			sleep(1);
		}
		mr_free(tmp);
		log_it("OK, ntfsclone has really finished");
	}

	if (strcmp(outfile_fname, "/dev/null")) {
		chown(outfile_fname, biggiestruct.properties.st_uid, biggiestruct.properties.st_gid);
		chmod(outfile_fname, biggiestruct.properties.st_mode);
		ubuf->actime = biggiestruct.properties.st_atime;
		ubuf->modtime = biggiestruct.properties.st_mtime;
		utime(outfile_fname, ubuf);
	}
	mr_free(outfile_fname);
	paranoid_free(bigblk);

	return (retval);
}

/**************************************************************************
 *END_ RESTORE_A_BIGGIEFILE_FROM_CD                                       *
 **************************************************************************/



/**
 * Restore a biggiefile from the currently opened stream.
 * @param bkpinfo The backup information structure. Fields used:
 * - @c bkpinfo->restore_path
 * - @c bkpinfo->zip_exe
 * @param orig_bf_fname The original filename of the biggiefile.
 * @param biggiefile_number The number of the biggiefile (starting from 0).
 * @param orig_checksum Unused.
 * @param biggiefile_size Unused.
 * @param filelist The node structure containing the list of files to be restored.
 * If @p orig_bf_fname is not in the list, it will be ignored.
 * @return 0 for success (or skip), nonzero for failure.
 * @bug orig_checksum and biggiefile_size are unused (except to check that they are non-NULL).
 */
int restore_a_biggiefile_from_stream(char *orig_bf_fname, long biggiefile_number, char *orig_checksum,	//UNUSED
									 long long biggiefile_size,	//UNUSED
									 struct s_node *filelist,
									 int use_ntfsprog,
									 char *pathname_of_last_file_restored)
{
	FILE *pout;
	FILE *fin;

  /** mallocs ********/
	char *tmp = NULL;
	char *tmp1 = NULL;
	char *command = NULL;
	char *outfile_fname = NULL;
	char *sz_devfile = NULL;
	char *ntfsprog_fifo = NULL;
	char *file_to_openout = NULL;

	struct s_node *node;

	int old_loglevel;
	long current_slice_number = 0;
	int retval = 0;
	int res = 0;
	int ctrl_chr = '\0';
	long long slice_siz;
	bool dummy_restore = FALSE;
	bool use_ntfsprog_hack = FALSE;
	pid_t pid;
	struct s_filename_and_lstat_info biggiestruct;
	struct utimbuf the_utime_buf, *ubuf;
	ubuf = &the_utime_buf;

	malloc_string(tmp);
	old_loglevel = g_loglevel;
	assert(bkpinfo != NULL);
	assert(orig_bf_fname != NULL);
	assert(orig_checksum != NULL);

	pathname_of_last_file_restored[0] = '\0';
	if (use_ntfsprog == BLK_START_A_PIHBIGGIE) {
		use_ntfsprog = 1;
		log_msg(1, "%s --- pih=YES", orig_bf_fname);
	} else if (use_ntfsprog == BLK_START_A_NORMBIGGIE) {
		use_ntfsprog = 0;
		log_msg(1, "%s --- pih=NO", orig_bf_fname);
	} else {
		use_ntfsprog = 0;
		log_msg(1, "%s --- pih=NO (weird marker though)", orig_bf_fname);
	}

	strncpy(pathname_of_last_file_restored, orig_bf_fname,
			MAX_STR_LEN - 1);
	pathname_of_last_file_restored[MAX_STR_LEN - 1] = '\0';

	/* open out to biggiefile to be restored (or /dev/null if biggiefile is not to be restored) */

	if (filelist != NULL) {
		node = find_string_at_node(filelist, orig_bf_fname);
		if (!node) {
			dummy_restore = TRUE;
			log_msg(1,
					"Skipping big file %ld (%s) - not in biggielist subset",
					biggiefile_number + 1, orig_bf_fname);
			pathname_of_last_file_restored[0] = '\0';
		} else if (!(node->selected)) {
			dummy_restore = TRUE;
			log_msg(1, "Skipping %s (name isn't in biggielist subset)",
					orig_bf_fname);
			pathname_of_last_file_restored[0] = '\0';
		}
	}

	if (use_ntfsprog) {
		if (strncmp(orig_bf_fname, "/dev/", 5)) {
			log_msg(1,
					"I was in error when I set use_ntfsprog to TRUE.");
			log_msg(1, "%s isn't even in /dev", orig_bf_fname);
			use_ntfsprog = FALSE;
		}
	}

	if (use_ntfsprog) {
		g_loglevel = 4;
		mr_asprintf(outfile_fname, "%s", orig_bf_fname);
		use_ntfsprog_hack = TRUE;
		log_msg(2, "Calling ntfsclone in background because %s is a /dev entry", outfile_fname);
		mr_asprintf(sz_devfile, "%s/%d.%d.000", bkpinfo->tmpdir, (int) (random() % 32768), (int) (random() % 32768));
		mkfifo(sz_devfile, 0x770);
		mr_asprintf(ntfsprog_fifo, "%s", sz_devfile);
		mr_free(sz_devfile);

		file_to_openout = ntfsprog_fifo;
		switch (pid = fork()) {
		case -1:
			fatal_error("Fork failure");
		case 0:
			log_msg(3, "CHILD - fip - calling feed_outfrom_ntfsprog(%s, %s)", outfile_fname, ntfsprog_fifo);
			res = feed_outfrom_ntfsprog(outfile_fname, ntfsprog_fifo);
			mr_free(ntfsprog_fifo);
			exit(res);
			break;
		default:
			log_msg(3, "feed_into_ntfsprog() called in background --- pid=%ld", (long int) (pid));
		}
		mr_free(ntfsprog_fifo);
	} else {
		if (!strncmp(orig_bf_fname, "/dev/", 5))	{
			// non-NTFS partition
			mr_asprintf(outfile_fname, "%s", orig_bf_fname);
		} else {
			// biggiefile
			mr_asprintf(outfile_fname, "%s/%s", bkpinfo->restore_path, orig_bf_fname);
		}
		use_ntfsprog_hack = FALSE;
		file_to_openout = outfile_fname;
		if (!does_file_exist(outfile_fname))	// yes, it looks weird with the '!' but it's correct that way
		{
			make_hole_for_file(outfile_fname);
		}
		log_msg(2, "Reassembling big file %ld (%s)", biggiefile_number + 1, orig_bf_fname);
	}

	if (dummy_restore) {
		mr_free(outfile_fname);
		mr_asprintf(outfile_fname, "/dev/null");
	}

	if (bkpinfo->zip_exe == NULL) {
		mr_asprintf(command, "cat > \"%s\"", file_to_openout);
	} else {
		mr_asprintf(command, "%s -dc > \"%s\" 2>> %s", bkpinfo->zip_exe, file_to_openout, MONDO_LOGFILE);
		if (strcmp(bkpinfo->zip_exe, "gzip") == 0) {
			/* Ignore SIGPIPE for gzip as it causes errors on big files
			 * Cf: http://trac.mondorescue.org/ticket/244 */
			signal(SIGPIPE,SIG_IGN);
		}
	}
	log_msg(3, "Pipe command = '%s'", command);

	/* restore biggiefile, one slice at a time */
	if (!(pout = popen(command, "w"))) {
		fatal_error("Cannot pipe out");
	}
	mr_free(command);

	for (res = read_header_block_from_stream(&slice_siz, tmp, &ctrl_chr);
		 ctrl_chr != BLK_STOP_A_BIGGIE;
		 res = read_header_block_from_stream(&slice_siz, tmp, &ctrl_chr)) {
		if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE) {
			wrong_marker(BLK_START_AN_AFIO_OR_SLICE, ctrl_chr);
		}
		log_msg(2, "Working on file #%ld, slice #%ld    ", biggiefile_number + 1, current_slice_number);
		if (!g_text_mode) {
			newtDrawRootText(0, g_noof_rows - 2, tmp);
			newtRefresh();
		}
		strip_spaces(tmp);
		update_progress_form(tmp);
		if (current_slice_number == 0) {
			res =
				read_file_from_stream_to_file("/tmp/biggie-blah.txt",
											  slice_siz);
			if (!(fin = fopen("/tmp/biggie-blah.txt", "r"))) {
				log_OS_error("blah blah");
			} else {
				if (fread
					((void *) &biggiestruct, 1, sizeof(biggiestruct),
					 fin) < sizeof(biggiestruct)) {
					log_msg(2,
							"Warning - unable to get biggiestruct of bigfile #%d",
							biggiefile_number + 1);
				}
				paranoid_fclose(fin);
			}
		} else {
			res =
				read_file_from_stream_to_stream(pout, slice_siz);
		}
		retval += res;
		res = read_header_block_from_stream(&slice_siz, tmp, &ctrl_chr);
		if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE) {
			wrong_marker(BLK_STOP_AN_AFIO_OR_SLICE, ctrl_chr);
		}
		current_slice_number++;
		g_current_progress++;
	}
	paranoid_pclose(pout);

	if (bkpinfo->zip_exe != NULL) {
		if (strcmp(bkpinfo->zip_exe, "gzip") == 0) {
			/* Re-enable SIGPIPE for gzip */
			signal(SIGPIPE, terminate_daemon);
		}
	}

	log_msg(1, "pathname_of_last_file_restored is now %s",
			pathname_of_last_file_restored);

	if (use_ntfsprog_hack) {
		log_msg(3, "Waiting for ntfsclone to finish");
		mr_asprintf(tmp1, " ps | grep \" ntfsclone \" | grep -v grep > /dev/null 2> /dev/null");
		while (system(tmp1) == 0) {
			sleep(1);
		}
		mr_free(tmp1);
		log_msg(3, "OK, ntfsclone has really finished");
	}

	log_msg(3, "biggiestruct.filename = %s", biggiestruct.filename);
	log_msg(3, "biggiestruct.checksum = %s", biggiestruct.checksum);
	if (strcmp(outfile_fname, "/dev/null")) {
		chmod(outfile_fname, biggiestruct.properties.st_mode);
		chown(outfile_fname, biggiestruct.properties.st_uid, biggiestruct.properties.st_gid);
		ubuf->actime = biggiestruct.properties.st_atime;
		ubuf->modtime = biggiestruct.properties.st_mtime;
		utime(outfile_fname, ubuf);
	}
	mr_free(outfile_fname);

	paranoid_free(tmp);
	g_loglevel = old_loglevel;
	return (retval);
}

/**************************************************************************
 *END_RESTORE_A_BIGGIEFILE_FROM_STREAM                                    *
 **************************************************************************/



/**
 * Restore @p tarball_fname from CD.
 * @param tarball_fname The filename of the tarball to restore (in /mnt/cdrom).
 * This will be used unmodified.
 * @param current_tarball_number The number (starting from 0) of the fileset
 * we're restoring now.
 * @param filelist The node structure containing the list of files to be
 * restored. If no file in the afioball is in this list, afio will still be
 * called, but nothing will be written.
 * @return 0 for success, nonzero for failure.
 */
int
restore_a_tarball_from_CD(char *tarball_fname,
						  long current_tarball_number,
						  struct s_node *filelist)
{
	int retval = 0;
	int res;
	char *p;

  /** malloc **/
	char *command = NULL;
	char *tmp = NULL;
	char *filelist_name = NULL;
	char *filelist_subset_fname = NULL;
	char *executable = NULL;
	char *temp_log = NULL;
	long matches = 0;
	bool use_star;
	char *xattr_fname = NULL;
	char *acl_fname = NULL;

	assert_string_is_neither_NULL_nor_zerolength(tarball_fname);

	log_msg(5, "Entering");
	use_star = (strstr(tarball_fname, ".star")) ? TRUE : FALSE;
	mr_asprintf(command, "mkdir -p %s/tmp", MNT_RESTORING);
	run_program_and_log_output(command, 9);
	paranoid_free(command);

	mr_asprintf(filelist_name, MNT_CDROM "/archives/filelist.%ld", current_tarball_number);
	if (length_of_file(filelist_name) <= 2) {
		log_msg(2, "There are _zero_ files in filelist '%s'", filelist_name);
		log_msg(2, "This is a bit silly (ask dev-team to fix mondo_makefilelist, please)");
		log_msg(2, "but it's non-critical. It's cosmetic. Don't worry about it.");
		retval = 0;
		mr_free(filelist_name);
		log_msg(5, "Leaving");
		return(0);
	}
	if (count_lines_in_file(filelist_name) <= 0 || length_of_file(tarball_fname) <= 0) {
		log_msg(3, "length_of_file(%s) = %llu", tarball_fname, length_of_file(tarball_fname));
		log_msg(3, "count_lines_in_file(%s) = %llu", tarball_fname, count_lines_in_file(tarball_fname));
		log_to_screen("Unable to restore fileset #%ld (CD I/O error)", current_tarball_number);
		mr_free(filelist_name);
		log_msg(5, "Leaving");
		return(1);
	}

	if (filelist) {
		mr_asprintf(filelist_subset_fname, "/tmp/filelist-subset-%ld.tmp", current_tarball_number);
		if ((matches =
			 save_filelist_entries_in_common(filelist_name, filelist,
											 filelist_subset_fname,
											 use_star)) <= 0) {
			log_msg(1, "Skipping fileset %ld", current_tarball_number);
		} else {
			log_msg(3, "Saved fileset %ld's subset to %s", current_tarball_number, filelist_subset_fname);
		}
		log_to_screen("Tarball #%ld --- %ld matches", current_tarball_number, matches);
	}
	mr_free(filelist_name);

	if (filelist == NULL || matches > 0) {
		if (g_getfattr) {
			mr_asprintf(xattr_fname, XATTR_LIST_FNAME_RAW_SZ, MNT_CDROM "/archives", current_tarball_number);
		}
		if (g_getfacl) {
			mr_asprintf(acl_fname, ACL_LIST_FNAME_RAW_SZ, MNT_CDROM "/archives", current_tarball_number);
		}
		if (strstr(tarball_fname, ".bz2")) {
			mr_asprintf(executable, "bzip2");
		} else if (strstr(tarball_fname, ".lzma")) {
			mr_asprintf(executable, "lzma");
		} else if (strstr(tarball_fname, ".gz")) {
			mr_asprintf(executable, "gzip");
		} else if (strstr(tarball_fname, ".lzo")) {
			mr_asprintf(executable, "lzop");
		}
		if (executable) {
			mr_asprintf(tmp, "which %s > /dev/null 2> /dev/null", executable);
			res = run_program_and_log_output(tmp, FALSE);
			mr_free(tmp);

			if (res) {
				log_to_screen("(compare_a_tarball) Compression program %s not found - oh no!", executable);
				paranoid_MR_finish(1);
			}
			tmp = executable;
			mr_asprintf(executable, "-P %s -Z", tmp);
			mr_free(tmp);
		}
#ifdef __FreeBSD__
#define BUFSIZE 512
#else
#define BUFSIZE (1024L*1024L)/TAPE_BLOCK_SIZE
#endif

		if (use_star) {
			mr_asprintf(command, "star -x -force-remove -U " STAR_ACL_SZ " errctl= file=%s", tarball_fname);
			if (strstr(tarball_fname, ".bz2")) {
				mr_strcat(command, " -bz");
			}
		} else {
			if (! executable) {
				log_msg(2, "Mo executable, this shouldn't happen !");
			} else {
				if (filelist_subset_fname != NULL) {
					mr_asprintf(command, "afio -i -M 8m -b %ld -c %ld %s -w '%s' %s", TAPE_BLOCK_SIZE, BUFSIZE, executable, filelist_subset_fname, tarball_fname);
				} else {
					mr_asprintf(command, "afio -i -b %ld -c %ld -M 8m %s %s", TAPE_BLOCK_SIZE, BUFSIZE, executable, tarball_fname);
				}
			}
		}
		mr_free(executable);

#undef BUFSIZE
		mr_asprintf(temp_log, "/tmp/%d.%d", (int) (random() % 32768), (int) (random() % 32768));

		mr_strcat(command, " 2>> %s >> %s", temp_log, temp_log);
		log_msg(1, "command = '%s'", command);
		unlink(temp_log);
		res = system(command);
		if (res) {
			p = strstr(command, "-acl ");
			if (p) {
				p[0] = p[1] = p[2] = p[3] = ' ';
				log_msg(1, "new command = '%s'", command);
				res = system(command);
			}
		}
		paranoid_free(command);

		if (res && length_of_file(temp_log) < 5) {
			res = 0;
		}

		if (g_getfattr) {
			log_msg(1, "Setting fattr list %s", xattr_fname);
			if (length_of_file(xattr_fname) > 0) {
				res = set_fattr_list(filelist_subset_fname, xattr_fname);
				if (res) {
					log_to_screen("Errors occurred while setting extended attributes");
				} else {
					log_msg(1, "I set xattr OK");
				}
				retval += res;
			}
		}
		if (g_getfacl) {
			log_msg(1, "Setting acl list %s", acl_fname);
			if (length_of_file(acl_fname) > 0) {
				res = set_acl_list(filelist_subset_fname, acl_fname);
				if (res) {
					log_to_screen
						("Errors occurred while setting access control lists");
				} else {
					log_msg(1, "I set ACL OK");
				}
				retval += res;
			}
		}
		if (retval) {
			mr_asprintf(command, "cat %s >> %s", temp_log, MONDO_LOGFILE);
			system(command);
			paranoid_free(command);

			log_msg(2, "Errors occurred while processing fileset #%d",
					current_tarball_number);
		} else {
			log_msg(2, "Fileset #%d processed OK", current_tarball_number);
		}
		unlink(temp_log);
		mr_free(temp_log);
	}
	if (does_file_exist("/PAUSE")) {
		popup_and_OK
			("Press ENTER to go on. Delete /PAUSE to stop these pauses.");
	}
	unlink(filelist_subset_fname);
	mr_free(filelist_subset_fname);
	if (g_getfattr) {
		unlink(xattr_fname);
		mr_free(xattr_fname);
	}
	if (g_getfacl) {
		unlink(acl_fname);
		mr_free(acl_fname);
	}

	log_msg(5, "Leaving");
	return (retval);
}

/**************************************************************************
 *END_RESTORE_A_TARBALL_FROM_CD                                           *
 **************************************************************************/


/**
 * Restore a tarball from the currently opened stream.
 * @param bkpinfo The backup information structure. Fields used:
 * - @c bkpinfo->backup_media_type
 * - @c bkpinfo->media_device
 * - @c bkpinfo->zip_exe
 * @param tarball_fname The filename of the afioball to restore.
 * @param current_tarball_number The number (starting from 0) of the fileset
 * we're restoring now.
 * @param filelist The node structure containing the list of files to be
 * restored. If no file in the afioball is in this list, afio will still be
 * called, but nothing will be written.
 * @param size The size (in @b bytes) of the afioball.
 * @return 0 for success, nonzero for failure.
 */
int
restore_a_tarball_from_stream(char *tarball_fname,
							  long current_tarball_number,
							  struct s_node *filelist,
							  long long size, char *xattr_fname,
							  char *acl_fname)
{
	int retval = 0;
	int res = 0;

  /** malloc add ***/
	char *mds = NULL;
	char *command = NULL;
	char *afio_fname = NULL;
	char *filelist_fname = NULL;
	char *filelist_subset_fname = NULL;
	char *executable = NULL;
	long matches = 0;
	bool restore_this_fileset = FALSE;
	bool use_star;

	assert(bkpinfo != NULL);
	assert_string_is_neither_NULL_nor_zerolength(tarball_fname);

	/* to do it with a file... */
	use_star = (strstr(tarball_fname, ".star")) ? TRUE : FALSE;
	mds = media_descriptor_string(bkpinfo->backup_media_type);
	log_msg(2, "Restoring from fileset #%ld (%ld KB) on %s #%d",
			current_tarball_number, (long) size >> 10, mds, g_current_media_number);
	mr_free(mds);

	run_program_and_log_output("mkdir -p " MNT_RESTORING "/tmp", FALSE);

  /****************************************************************************
   * Use RAMDISK's /tmp; saves time; oh wait, it's too small                  *
   * Well, pipe from tape to afio, then; oh wait, can't do that either: bug   *
   * in afio or someting; oh darn.. OK, use tmpfs :-)                         *
   ****************************************************************************/
	mr_asprintf(afio_fname, "/tmp/tmpfs/archive.tmp.%ld", current_tarball_number);
	mr_asprintf(filelist_fname, "%s/filelist.%ld", bkpinfo->tmpdir, current_tarball_number);
	mr_asprintf(filelist_subset_fname, "%s/filelist-subset-%ld.tmp", bkpinfo->tmpdir, current_tarball_number);

	res = read_file_from_stream_to_file(afio_fname, size);
	if (strstr(tarball_fname, ".star")) {
		bkpinfo->use_star = TRUE;
	}
	if (res) {
		log_msg(1, "Warning - error reading afioball from tape");
	}
	if (bkpinfo->compression_level == 0) {
		mr_asprintf(executable, "%s", "");
	} else {
		if (bkpinfo->use_star) {
			mr_asprintf(executable, "%s", " -bz");
		} else {
			mr_asprintf(executable, "-P %s -Z", bkpinfo->zip_exe);
		}
	}

	if (!filelist)				// if unconditional restore then restore entire fileset
	{
		restore_this_fileset = TRUE;
	} else						// If restoring selectively then get TOC from tarball
	{
		if (strstr(tarball_fname, ".star.")) {
			use_star = TRUE;
			mr_asprintf(command, "star -t file=%s %s", afio_fname, executable);
		} else {
			use_star = FALSE;
			mr_asprintf(command, "afio -t -M 8m -b %ld %s %s", TAPE_BLOCK_SIZE, executable, afio_fname);
		}
		mr_strcat(command, " > %s 2>> %s", filelist_fname, MONDO_LOGFILE);
		log_msg(1, "command = %s", command);
		if (system(command)) {
			log_msg(4, "Warning - error occurred while retrieving TOC");
		}
		mr_free(command);

		if ((matches =
			 save_filelist_entries_in_common(filelist_fname, filelist,
											 filelist_subset_fname,
											 use_star))
			<= 0 || length_of_file(filelist_subset_fname) < 2) {
			if (length_of_file(filelist_subset_fname) < 2) {
				log_msg(1, "No matches found in fileset %ld",
						current_tarball_number);
			}
			log_msg(2, "Skipping fileset %ld", current_tarball_number);
			restore_this_fileset = FALSE;
		} else {
			log_msg(5, "%ld matches. Saved fileset %ld's subset to %s",
					matches, current_tarball_number,
					filelist_subset_fname);
			restore_this_fileset = TRUE;
		}
	}

// Concoct the call to star/afio to restore files
	if (strstr(tarball_fname, ".star.")) {
		// star
		mr_asprintf(command, "star -x file=%s %s", afio_fname, executable);
		if (filelist) {
			mr_strcat(command, " list=%s", filelist_subset_fname);
		}
	} else {
		// afio
		mr_asprintf(command, "afio -i -M 8m -b %ld %s", TAPE_BLOCK_SIZE, executable);
		if (filelist) {
			mr_strcat(command, " -w %s", filelist_subset_fname);
		}
		mr_strcat(command, " %s", afio_fname);
	}
	mr_strcat(command, " 2>> %s", MONDO_LOGFILE);
	mr_free(executable);

// Call if IF there are files to restore (selectively/unconditionally)
	if (restore_this_fileset) {
		log_msg(1, "Calling command='%s'", command);
		paranoid_system(command);

		if (g_getfattr) {
			log_it("Restoring xattr stuff");
			res = set_fattr_list(filelist_subset_fname, xattr_fname);
			if (res) {
				log_msg(1, "Errors occurred while setting xattr");
			} else {
				log_msg(1, "I set xattr OK");
			}
			retval += res;
		}

		if (g_getfacl) {
			log_it("Restoring acl stuff");
			res = set_acl_list(filelist_subset_fname, acl_fname);
			if (res) {
				log_msg(1, "Errors occurred while setting ACL");
			} else {
				log_msg(1, "I set ACL OK");
			}
			retval += res;
		}

	} else {
		log_msg(1, "NOT CALLING '%s'", command);
	}
	mr_free(command);

	if (does_file_exist("/PAUSE") && current_tarball_number >= 50) {
		log_to_screen("Paused after set %ld", current_tarball_number);
		popup_and_OK("Pausing. Press ENTER to continue.");
	}

	unlink(filelist_subset_fname);
	mr_free(filelist_subset_fname);
	unlink(filelist_fname);
	mr_free(filelist_fname);
	unlink(afio_fname);
	mr_free(afio_fname);

	return (retval);
}

/**************************************************************************
 *END_RESTORE_A_TARBALL_FROM_STREAM                                       *
 **************************************************************************/




/**
 * Restore all biggiefiles from all media in this CD backup.
 * The CD with the last afioball should be currently mounted.
 * @param bkpinfo The backup information structure. @c backup_media_type is the
 * only field used in this function.
 * @param filelist The node structure containing the list of files to be
 * restored. If a prospective biggiefile is not in this list, it will be ignored.
 * @return 0 for success, nonzero for failure.
 */
int restore_all_biggiefiles_from_CD(struct s_node *filelist) {

	int retval = 0;
	int res = 0;
	long noof_biggiefiles, bigfileno = 0, total_slices;
  /** malloc **/
	char *tmp1 = NULL;
	char *mds = NULL;
	bool just_changed_cds = FALSE;
	char *xattr_fname = NULL;
	char *acl_fname = NULL;
	char *biggies_whose_EXATs_we_should_set = NULL;	// EXtended ATtributes
	char *pathname_of_last_biggie_restored;
	FILE *fbw = NULL;

	malloc_string(pathname_of_last_biggie_restored);
	assert(bkpinfo != NULL);

	mr_asprintf(biggies_whose_EXATs_we_should_set, "%s/biggies-whose-EXATs-we-should-set", bkpinfo->tmpdir);
	if (!(fbw = fopen(biggies_whose_EXATs_we_should_set, "w"))) {
		log_msg(1, "Warning - cannot openout %s", biggies_whose_EXATs_we_should_set);
	}

	tmp1 = read_cfg_var(MINDI_CACHE"/mondorestore.cfg", "total-slices");
	total_slices = atol(tmp1);
	mr_free(tmp1);

	mr_asprintf(tmp1, "Reassembling large files      ");
	mvaddstr_and_log_it(g_currentY, 0, tmp1);
	mr_free(tmp1);

	if (length_of_file(BIGGIELIST) < 6) {
		log_msg(1, "OK, no biggielist; not restoring biggiefiles");
		return (0);
	}
	noof_biggiefiles = count_lines_in_file(BIGGIELIST);
	if (noof_biggiefiles <= 0) {
		log_msg(2, "OK, no biggiefiles in biggielist; not restoring biggiefiles");
		return (0);
	}
	log_msg(2, "OK, there are %ld biggiefiles in the archives", noof_biggiefiles);

	open_progress_form("Reassembling large files",
					   "I am now reassembling all the large files.",
					   "Please wait. This may take some time.",
					   "", total_slices);
	for (bigfileno = 0 ; bigfileno < noof_biggiefiles ;) {
		log_msg(2, "Thinking about restoring bigfile %ld", bigfileno + 1);
		if (!does_file_exist(slice_fname(bigfileno, 0, ARCHIVES_PATH, ""))) {
			log_msg(3, "...but its first slice isn't on this CD. Perhaps this was a selective restore?");
			mds = media_descriptor_string(bkpinfo->backup_media_type);
			log_msg(3, "Cannot find bigfile #%ld 's first slice on %s #%d", bigfileno + 1, mds, g_current_media_number);
			log_msg(3, "Slicename would have been %s",
					slice_fname(bigfileno, 0, ARCHIVES_PATH, ""));
			// I'm not positive 'just_changed_cds' is even necessary...
			if (just_changed_cds) {
				just_changed_cds = FALSE;
				log_msg(3, "I'll continue to scan this CD for bigfiles to be restored.");
			} else if (does_file_exist(MNT_CDROM "/archives/NOT-THE-LAST")) {
				insist_on_this_cd_number(++g_current_media_number);
				log_to_screen("Restoring from %s #%d", mds, g_current_media_number);
				just_changed_cds = TRUE;
			} else {
				/* That big file doesn't exist, but the followings may */
				/* So we need to continue looping */
				log_msg(2, "There was no bigfile #%ld. That's OK.", bigfileno + 1);
				log_msg(2, "I'm going to stop restoring bigfiles now.");
				retval++;
				bigfileno++;
			}
			mr_free(mds);
		} else {
			just_changed_cds = FALSE;
			mr_asprintf(tmp1, "Restoring big file %ld", bigfileno + 1);
			update_progress_form(tmp1);
			mr_free(tmp1);
			res = restore_a_biggiefile_from_CD(bigfileno, filelist, pathname_of_last_biggie_restored);
			log_it("%s",pathname_of_last_biggie_restored);
			if (fbw && pathname_of_last_biggie_restored[0]) {
				fprintf(fbw, "%s\n", pathname_of_last_biggie_restored);
			}
			retval += res;
			bigfileno++;

		}
	}

	if (fbw) {
		fclose(fbw);
		if (g_getfattr) {
			mr_asprintf(xattr_fname, XATTR_BIGGLST_FNAME_RAW_SZ, ARCHIVES_PATH);
			if (length_of_file(xattr_fname) > 0) {
				set_fattr_list(biggies_whose_EXATs_we_should_set, xattr_fname);
			}
			mr_free(xattr_fname);
		}
		if (g_getfacl) {
			mr_asprintf(acl_fname, ACL_BIGGLST_FNAME_RAW_SZ, ARCHIVES_PATH);
			if (length_of_file(acl_fname) > 0) {
				set_acl_list(biggies_whose_EXATs_we_should_set, acl_fname);
			}
			mr_free(acl_fname);
		}
	}
	mr_free(biggies_whose_EXATs_we_should_set);

	if (does_file_exist("/PAUSE")) {
		popup_and_OK("Press ENTER to go on. Delete /PAUSE to stop these pauses.");
	}
	close_progress_form();
	if (retval) {
		mvaddstr_and_log_it(g_currentY++, 74, "Errors.");
	} else {
		mvaddstr_and_log_it(g_currentY++, 74, "Done.");
	}
	paranoid_free(pathname_of_last_biggie_restored);
	return (retval);
}

/**************************************************************************
 *END_RESTORE_ALL_BIGGIFILES_FROM_CD                                      *
 **************************************************************************/



/**
 * Restore all afioballs from all CDs in the backup.
 * The first CD should be inserted (if not, it will be asked for).
 * @param bkpinfo The backup information structure. @c backup_media_type is the
 * only field used in @e this function.
 * @param filelist The node structure containing the list of files to be
 * restored. If no file in some particular afioball is in this list, afio will
 * still be called for that fileset, but nothing will be written.
 * @return 0 for success, or the number of filesets that failed.
 */
int
restore_all_tarballs_from_CD(struct s_node *filelist)
{
	int retval = 0;
	int res;
	int attempts;
	long current_tarball_number = 0;
	long max_val;
  /**malloc ***/
	char *mds = NULL;
	char *tmp1 = NULL;
	char *tarball_fname = NULL;
	char *progress_str = NULL;

	assert(bkpinfo != NULL);

	mvaddstr_and_log_it(g_currentY, 0, "Restoring from archives");
	log_msg(2, "Insisting on 1st media, so that I can have a look at LAST-FILELIST-NUMBER");
	if (g_current_media_number != 1) {
		log_msg(3, "OK, that's jacked up.");
		g_current_media_number = 1;
	}
	insist_on_this_cd_number(g_current_media_number);
	tmp1 = read_cfg_var(MINDI_CACHE"/mondorestore.cfg", "last-filelist-number");
	max_val = atol(tmp1) + 1;
	mr_free(tmp1);

	mds = media_descriptor_string(bkpinfo->backup_media_type);
	mr_asprintf(progress_str, "Restoring from %s #%d", mds, g_current_media_number);

	log_to_screen(progress_str);
	open_progress_form("Restoring from archives",
					   "Restoring data from the archives.",
					   "Please wait. This may take some time.",
					   progress_str, max_val);
	for (;;) {
		insist_on_this_cd_number(g_current_media_number);
		update_progress_form(progress_str);
		mr_free(progress_str);

		mr_asprintf(tarball_fname, MNT_CDROM "/archives/%ld.afio.bz2", current_tarball_number);
		if (!does_file_exist(tarball_fname)) {
			mr_free(tarball_fname);
			mr_asprintf(tarball_fname, MNT_CDROM "/archives/%ld.afio.gz", current_tarball_number);
		}
		if (!does_file_exist(tarball_fname)) {
			mr_free(tarball_fname);
			mr_asprintf(tarball_fname, MNT_CDROM "/archives/%ld.afio.lzma", current_tarball_number);
		}
		if (!does_file_exist(tarball_fname)) {
			mr_free(tarball_fname);
			mr_asprintf(tarball_fname, MNT_CDROM "/archives/%ld.afio.lzo", current_tarball_number);
		}
		if (!does_file_exist(tarball_fname)) {
			mr_free(tarball_fname);
			mr_asprintf(tarball_fname, MNT_CDROM "/archives/%ld.afio.", current_tarball_number);
		}
		if (!does_file_exist(tarball_fname)) {
			mr_free(tarball_fname);
			mr_asprintf(tarball_fname, MNT_CDROM "/archives/%ld.star.bz2", current_tarball_number);
		}
		if (!does_file_exist(tarball_fname)) {
			mr_free(tarball_fname);
			mr_asprintf(tarball_fname, MNT_CDROM "/archives/%ld.star.", current_tarball_number);
		}
		if (!does_file_exist(tarball_fname)) {
			if (current_tarball_number == 0) {
				log_to_screen
					("No tarballs. Strange. Maybe you only backed up freakin' big files?");
				mr_free(tarball_fname);
				return (0);
			}
			if (!does_file_exist(MNT_CDROM "/archives/NOT-THE-LAST")
				|| system("find " MNT_CDROM
						  "/archives/slice* > /dev/null 2> /dev/null") ==
				0) {
				break;
			}
			g_current_media_number++;
			mr_asprintf(progress_str, "Restoring from %s #%d", media_descriptor_string(bkpinfo->backup_media_type), g_current_media_number);
			log_to_screen(progress_str);
		} else {
			mr_asprintf(progress_str, "Restoring from fileset #%ld on %s #%d", current_tarball_number, mds, g_current_media_number);
			for (res = 999, attempts = 0; attempts < 3 && res != 0; attempts++) {
				res = restore_a_tarball_from_CD(tarball_fname, current_tarball_number, filelist);
			}
			mr_asprintf(tmp1, "%s #%d, fileset #%ld - restore ", mds, g_current_media_number, current_tarball_number);
			if (res) {
				mr_strcat(tmp1, "reported errors");
			} else if (attempts > 1) {
				mr_strcat(tmp1, "succeeded");
			} else {
				mr_strcat(tmp1, "succeeded");
			}
			if (attempts > 1) {
				mr_strcat(tmp1, " (%d attempts) - review logs", attempts);
			}
			if (attempts > 1) {
				log_to_screen(tmp1);
			}
			mr_free(tmp1);

			retval += res;
			current_tarball_number++;
			g_current_progress++;
		}
		mr_free(tarball_fname);

		/* Now we need to umount the current media to have the next mounted by insist_on_this_cd_number */
		run_program_and_log_output("umount " MNT_CDROM, FALSE);
	}
	mr_free(mds);
	mr_free(progress_str);

	close_progress_form();
	if (retval) {
		mvaddstr_and_log_it(g_currentY++, 74, "Errors.");
	} else {
		mvaddstr_and_log_it(g_currentY++, 74, "Done.");
	}

	return (retval);
}

/**************************************************************************
 *END_RESTORE_ALL_TARBALLS_FROM_CD                                        *
 **************************************************************************/



/**
 * Restore all biggiefiles from the currently opened stream.
 * @param bkpinfo The backup information structure. Passed to other functions.
 * @param filelist The node structure containing the list of files to be
 * restored. If a prospective biggiefile is not in the list, it will be ignored.
 * @return 0 for success, or the number of biggiefiles that failed.
 */
int
restore_all_biggiefiles_from_stream(struct s_node *filelist)
{
	long noof_biggiefiles;
	long current_bigfile_number = 0;
	long total_slices;

	int retval = 0;
	int res = 0;
	int ctrl_chr;

  /** malloc add ****/
	char *tmp1 = NULL;
	char *biggie_fname;
	char *biggie_cksum;
	char *xattr_fname = NULL;
	char *acl_fname = NULL;
	char *p;
	char *pathname_of_last_biggie_restored;
	char *biggies_whose_EXATs_we_should_set = NULL;	// EXtended ATtributes
	long long biggie_size;
	FILE *fbw = NULL;

	malloc_string(biggie_fname);
	malloc_string(biggie_cksum);
	malloc_string(pathname_of_last_biggie_restored);
	assert(bkpinfo != NULL);

	tmp1 = read_cfg_var(MINDI_CACHE"/mondorestore.cfg", "total-slices");
	total_slices = atol(tmp1);
	mr_free(tmp1);

	if (g_getfattr) {
		mr_asprintf(xattr_fname, XATTR_BIGGLST_FNAME_RAW_SZ, bkpinfo->tmpdir);
	}
	if (g_getfacl) {
		mr_asprintf(acl_fname, ACL_BIGGLST_FNAME_RAW_SZ, bkpinfo->tmpdir);
	}
	mr_asprintf(tmp1, "Reassembling large files      ");
	mvaddstr_and_log_it(g_currentY, 0, tmp1);
	mr_free(tmp1);

	mr_asprintf(biggies_whose_EXATs_we_should_set, "%s/biggies-whose-EXATs-we-should-set", bkpinfo->tmpdir);
	if (!(fbw = fopen(biggies_whose_EXATs_we_should_set, "w"))) {
		log_msg(1, "Warning - cannot openout %s", biggies_whose_EXATs_we_should_set);
	}

	// get xattr and acl files if they're there
	res = read_header_block_from_stream(&biggie_size, biggie_fname, &ctrl_chr);
	if (ctrl_chr == BLK_START_EXTENDED_ATTRIBUTES) {
		res =
			read_EXAT_files_from_tape(&biggie_size, biggie_fname, &ctrl_chr, xattr_fname, acl_fname);
	}

	noof_biggiefiles = atol(biggie_fname);
	log_msg(2, "OK, there are %ld biggiefiles in the archives", noof_biggiefiles);
	open_progress_form("Reassembling large files",
					   "I am now reassembling all the large files.",
					   "Please wait. This may take some time.",
					   "", total_slices);

	for (res =
		 read_header_block_from_stream(&biggie_size, biggie_fname,
									   &ctrl_chr);
		 ctrl_chr != BLK_STOP_BIGGIEFILES;
		 res =
		 read_header_block_from_stream(&biggie_size, biggie_fname,
									   &ctrl_chr)) {
		if (ctrl_chr != BLK_START_A_NORMBIGGIE
			&& ctrl_chr != BLK_START_A_PIHBIGGIE) {
			wrong_marker(BLK_START_A_NORMBIGGIE, ctrl_chr);
		}
		p = strrchr(biggie_fname, '/');
		if (!p) {
			p = biggie_fname;
		} else {
			p++;
		}
		mr_asprintf(tmp1, "Restoring big file %ld (%lld K)", current_bigfile_number + 1, biggie_size / 1024);
		update_progress_form(tmp1);
		mr_free(tmp1);
		res = restore_a_biggiefile_from_stream(biggie_fname,
											   current_bigfile_number,
											   biggie_cksum,
											   biggie_size,
											   filelist, ctrl_chr,
											   pathname_of_last_biggie_restored);
		log_msg(1, "I believe I have restored %s",
				pathname_of_last_biggie_restored);
		if (fbw && pathname_of_last_biggie_restored[0]) {
			fprintf(fbw, "%s\n", pathname_of_last_biggie_restored);
		}
		retval += res;
		current_bigfile_number++;

	}
	if (current_bigfile_number != noof_biggiefiles
		&& noof_biggiefiles != 0) {
		log_msg(1, "Warning - bigfileno=%ld but noof_biggiefiles=%ld\n", current_bigfile_number, noof_biggiefiles);
	} else {
		log_msg(1, "%ld biggiefiles in biggielist.txt; %ld biggiefiles processed today.", noof_biggiefiles, current_bigfile_number);
	}

	if (fbw) {
		fclose(fbw);
		if (length_of_file(biggies_whose_EXATs_we_should_set) > 2) {
			log_it("Setting biggie-EXATs");
			if (g_getfattr) {
				if (length_of_file(xattr_fname) > 0) {
					log_msg(1, "set_fattr_List(%s,%s)", biggies_whose_EXATs_we_should_set, xattr_fname);
					set_fattr_list(biggies_whose_EXATs_we_should_set, xattr_fname);
				}
			}
			if (g_getfacl) {
				if (length_of_file(acl_fname) > 0) {
					log_msg(1, "set_acl_list(%s,%s)", biggies_whose_EXATs_we_should_set, acl_fname);
					set_acl_list(biggies_whose_EXATs_we_should_set, acl_fname);
				}
			}
		} else {
			log_it("No biggiefiles selected. So, no biggie-EXATs to set.");
		}
	}
	mr_free(xattr_fname);
	mr_free(acl_fname);
	mr_free(biggies_whose_EXATs_we_should_set);

	if (does_file_exist("/PAUSE")) {
		popup_and_OK
			("Press ENTER to go on. Delete /PAUSE to stop these pauses.");
	}

	close_progress_form();
	if (retval) {
		mvaddstr_and_log_it(g_currentY++, 74, "Errors.");
	} else {
		mvaddstr_and_log_it(g_currentY++, 74, "Done.");
	}
	paranoid_free(pathname_of_last_biggie_restored);
	paranoid_free(biggie_fname);
	paranoid_free(biggie_cksum);
	return (retval);
}

/**************************************************************************
 *END_RESTORE_ALL_BIGGIEFILES_FROM_STREAM                                 *
 **************************************************************************/






/**
 * Restore all afioballs from the currently opened tape stream.
 * @param bkpinfo The backup information structure. Fields used:
 * - @c bkpinfo->backup_media_type
 * - @c bkpinfo->restore_path
 * @param filelist The node structure containing the list of files to be
 * restored. If no file in an afioball is in this list, afio will still be
 * called for that fileset, but nothing will be written.
 * @return 0 for success, or the number of filesets that failed.
 */
int restore_all_tarballs_from_stream(struct s_node *filelist)
{
	int retval = 0;
	int res;
	long current_afioball_number = 0;
	int ctrl_chr;
	long max_val /*, total_noof_files */ ;

  /** malloc **/
	char *tmp = NULL;
	char *mds = NULL;
	char *progress_str = NULL;
	char *tmp_fname;
	char *xattr_fname = NULL;
	char *acl_fname = NULL;

	long long tmp_size;

	malloc_string(tmp_fname);
	assert(bkpinfo != NULL);
	mvaddstr_and_log_it(g_currentY, 0, "Restoring from archives");
	tmp = read_cfg_var(MINDI_CACHE"/mondorestore.cfg", "last-filelist-number");
	max_val = atol(tmp) + 1;
	mr_free(tmp);

	chdir(bkpinfo->restore_path);	/* I don't know why this is needed _here_ but it seems to be. -HR, 02/04/2002 */

	run_program_and_log_output("pwd", 5);

	mr_asprintf(progress_str, "Restoring from media #%d", g_current_media_number);
	log_to_screen(progress_str);
	open_progress_form("Restoring from archives",
					   "Restoring data from the archives.",
					   "Please wait. This may take some time.",
					   progress_str, max_val);

	log_msg(3, "hey");

	res = read_header_block_from_stream(&tmp_size, tmp_fname, &ctrl_chr);
	if (res) {
		log_msg(2, "Warning - error reading afioball from tape");
	}
	retval += res;
	if (ctrl_chr != BLK_START_AFIOBALLS) {
		wrong_marker(BLK_START_AFIOBALLS, ctrl_chr);
	}
	log_msg(2, "ho");
	res = read_header_block_from_stream(&tmp_size, tmp_fname, &ctrl_chr);
	while (ctrl_chr != BLK_STOP_AFIOBALLS) {
		update_progress_form(progress_str);
		if (g_getfattr) {
			mr_asprintf(xattr_fname, "%s/xattr-subset-%ld.tmp", bkpinfo->tmpdir, current_afioball_number);
			unlink(xattr_fname);
		}
		if (g_getfacl) {
			mr_asprintf(acl_fname, "%s/acl-subset-%ld.tmp", bkpinfo->tmpdir, current_afioball_number);
			unlink(acl_fname);
		}
		if (ctrl_chr == BLK_START_EXTENDED_ATTRIBUTES) {
			log_it("Reading EXAT files from tape");
			res = read_EXAT_files_from_tape(&tmp_size, tmp_fname, &ctrl_chr, xattr_fname, acl_fname);
		}
		if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE) {
			wrong_marker(BLK_START_AN_AFIO_OR_SLICE, ctrl_chr);
		}
		log_msg(4, "Restoring from fileset #%ld (name=%s, size=%ld K)", current_afioball_number, tmp_fname, (long) tmp_size >> 10);
		res = restore_a_tarball_from_stream(tmp_fname, current_afioball_number, filelist, tmp_size, xattr_fname, acl_fname);
		retval += res;
		if (res) {
			log_to_screen("Fileset %ld - errors occurred", current_afioball_number);
		}
		res =
			read_header_block_from_stream(&tmp_size, tmp_fname, &ctrl_chr);
		if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE) {
			wrong_marker(BLK_STOP_AN_AFIO_OR_SLICE, ctrl_chr);
		}

		current_afioball_number++;
		g_current_progress++;
		mds = media_descriptor_string(bkpinfo->backup_media_type),

		mr_free(progress_str);
		mr_asprintf(progress_str, "Restoring from fileset #%ld on %s #%d", current_afioball_number, mds, g_current_media_number);
		mr_free(mds);
		res = read_header_block_from_stream(&tmp_size, tmp_fname, &ctrl_chr);
		if (g_getfattr) {
			unlink(xattr_fname);
		}
		if (g_getfacl) {
			unlink(acl_fname);
		}
	}							// next
	mr_free(progress_str);
	if (g_getfattr) {
		mr_free(xattr_fname);
	}
	if (g_getfacl) {
		mr_free(acl_fname);
	}

	log_msg(1, "All done with afioballs");
	close_progress_form();
	if (retval) {
		mvaddstr_and_log_it(g_currentY++, 74, "Errors.");
	} else {
		mvaddstr_and_log_it(g_currentY++, 74, "Done.");
	}
	paranoid_free(tmp_fname);
	return (retval);
}

/**************************************************************************
 *END_ RESTORE_ALL_TARBALLS_FROM_STREAM                                   *
 **************************************************************************/

/* @} - end of LLrestoreGroup */


/**
 * Restore all files in @p filelist.
 * @param bkpinfo The backup information structure. Most fields are used.
 * @param filelist The node structure containing the list of files to be
 * restored.
 * @return 0 for success, or the number of afioballs and biggiefiles that failed.
 * @ingroup restoreGroup
 */
int restore_everything(struct s_node *filelist)
{
	int resA;
	int resB;

  /** mallco ***/
	char *cwd;
	char *newpath;
	char *tmp = NULL;
	assert(bkpinfo != NULL);

	malloc_string(cwd);
	malloc_string(newpath);
	log_msg(2, "restore_everything() --- starting");
	g_current_media_number = 1;
	getcwd(cwd, MAX_STR_LEN - 1);
	mr_asprintf(tmp, "mkdir -p %s", bkpinfo->restore_path);
	run_program_and_log_output(tmp, FALSE);
	mr_free(tmp);

	log_msg(1, "Changing dir to %s", bkpinfo->restore_path);
	chdir(bkpinfo->restore_path);
	getcwd(newpath, MAX_STR_LEN - 1);
	log_msg(1, "path is now %s", newpath);
	log_msg(1, "restoring everything");
	tmp = find_home_of_exe("petris");
	if (!tmp && !g_text_mode) {
		newtDrawRootText(0, g_noof_rows - 2,
						 "Press ALT-<left cursor> twice to play Petris :-) ");
		newtRefresh();
	}
	mr_free(tmp);

	mvaddstr_and_log_it(g_currentY, 0, "Preparing to read your archives");
	mount_media();
	if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type)) {
		mvaddstr_and_log_it(g_currentY++, 0,
							"Restoring OS and data from streaming media");
		if (bkpinfo->backup_media_type == cdstream) {
			openin_cdstream();
		} else {
			openin_tape();
		}
		resA = restore_all_tarballs_from_stream(filelist);
		resB = restore_all_biggiefiles_from_stream(filelist);
		if (bkpinfo->backup_media_type == cdstream) {
			closein_cdstream();
		} else {
			closein_tape();
		}
	} else {
		mvaddstr_and_log_it(g_currentY++, 0,
							"Restoring OS and data from CD/USB   ");
		resA = restore_all_tarballs_from_CD(filelist);
		resB = restore_all_biggiefiles_from_CD(filelist);
	}
	chdir(cwd);
	if (resA + resB) {
		log_to_screen("Errors occurred while data was being restored.");
	}
	if (length_of_file("/etc/raidtab") > 0) {
		log_msg(2, "Copying local raidtab to restored filesystem");
		run_program_and_log_output("cp -f /etc/raidtab " MNT_RESTORING
								   "/etc/raidtab", FALSE);
	}
	kill_petris();
	log_msg(2, "restore_everything() --- leaving");
	paranoid_free(cwd);
	paranoid_free(newpath);
	return (resA + resB);
}

/**************************************************************************
 *END_RESTORE_EVERYTHING                                                  *
 **************************************************************************/


extern void wait_until_software_raids_are_prepped(char *, int);


char which_restore_mode(void);


/**
 * Log a "don't panic" message to the logfile.
 */
void welcome_to_mondorestore()
{
	log_msg(0, "-------------- Mondo Restore v%s -------------", PACKAGE_VERSION);
	log_msg(0, "DON'T PANIC! Mondorestore logs almost everything, so please ");
	log_msg(0, "don't break out in a cold sweat just because you see a few  ");
	log_msg(0, "error messages in the log. Read them; analyze them; see if  ");
	log_msg(0, "they are significant; above all, verify your backups! Please");
	log_msg(0, "attach a compressed copy of this log to any e-mail you send ");
	log_msg(0, "to the Mondo mailing list when you are seeking technical    ");
	log_msg(0, "support. Without it, we can't help you.            - DevTeam");
	log_msg(0, "------------------------------------------------------------");
	log_msg(0, "BTW, despite (or perhaps because of) the wealth of messages,");
	log_msg(0, "some users are inclined to stop reading this log.  If Mondo ");
	log_msg(0, "stopped for some reason, chances are it's detailed here.    ");
	log_msg(0, "More than likely there's a message at the very end of this  ");
	log_msg(0, "log that will tell you what is wrong.  Please read it!      ");
	log_msg(0, "------------------------------------------------------------");
}



/**
 * Restore the user's data.
 * What did you think it did, anyway? :-)
 */
int main(int argc, char *argv[])
{
	FILE *fin;
	FILE *fout;
	int retval = 0;
	int res;
	char *tmp = NULL;

	struct mountlist_itself *mountlist;
	struct raidlist_itself *raidlist;
	struct s_node *filelist;
	char *tmp1 = NULL;
	char *tmp2 = NULL;
	bool run_postnuke = FALSE;

	if (getuid() != 0) {
		fprintf(stderr, "Please run as root.\r\n");
		exit(127);
	}
	bkpinfo = (struct s_bkpinfo *)mr_malloc(sizeof(struct s_bkpinfo));
	init_bkpinfo();

	g_loglevel = DEFAULT_MR_LOGLEVEL;

	/* Configure global variables */
	malloc_libmondo_global_strings();
	tmp1 = call_program_and_get_last_line_of_output("cat " CMDLINE,TRUE);
	if (strstr(tmp1, "textonly")) {
		g_text_mode = TRUE;
		log_msg(1, "TEXTONLY MODE");
	} else {
		g_text_mode = FALSE;
	}							// newt :-)
	mr_free(tmp1);

	/* Init GUI */
	setup_newt_stuff();			/* call newtInit and setup screen log */

	tmp1 = call_program_and_get_last_line_of_output("which mondorestore",TRUE);
	strcpy(g_mondo_home, tmp1);
	mr_free(tmp1);

	g_current_media_number = 1;	// precaution

	run_program_and_log_output("mkdir -p " MNT_CDROM, FALSE);

	setup_MR_global_filenames();	// malloc() and set globals, using bkpinfo->tmpdir etc.
	bkpinfo->backup_media_type = none;	// in case boot disk was made for one backup type but user wants to restore from another backup type
	bkpinfo->restore_data = TRUE;	// Well, yeah :-)
	if (am_I_in_disaster_recovery_mode()) {
		run_program_and_log_output("mount / -o remount,rw", 2);
	}							// for b0rken distros
	g_main_pid = getpid();
	srandom((int) (time(NULL)));
	set_signals(TRUE);
	g_kernel_version = get_kernel_version();

	log_msg(1, "FYI - mountlist = %s", MINDI_CACHE"/mountlist.txt");
	mkdir(MNT_CDROM, 0x770);
	make_hole_for_dir(MONDO_CACHE);

	/* Backup original mountlist.txt */
	mr_asprintf(tmp, "cp -f "MINDI_CACHE"/mountlist.txt "MINDI_CACHE"/mountlist.txt.orig");
	run_program_and_log_output(tmp, FALSE);
	mr_free(tmp);

	/* Init directories */
	make_hole_for_dir("/var/log");
	make_hole_for_dir("/tmp/tmpfs");	/* just in case... */
	run_program_and_log_output("umount " MNT_CDROM, FALSE);

	run_program_and_log_output("rm -Rf /tmp/tmpfs/mondo.tmp.*", FALSE);

	welcome_to_mondorestore();
	if (bkpinfo->disaster_recovery) {
		log_msg(1, "I am in disaster recovery mode");
	} else {
		log_msg(1, "I am in normal, live mode");
	}

	log_it("what time is it");

	mountlist = (struct mountlist_itself *)mr_malloc(sizeof(struct mountlist_itself));
	raidlist = (struct raidlist_itself *)mr_malloc(sizeof(struct raidlist_itself));

	/* Process command-line parameters */
	if (argc == 2 && strcmp(argv[1], "--edit-mountlist") == 0) {
#ifdef __FreeBSD__
		system("mv -f /tmp/raidconf.txt /etc/raidtab");
		if (!does_file_exist("/etc/raidtab"))
			system("vinum printconfig > /etc/raidtab");
#endif
		load_raidtab_into_raidlist(raidlist, RAIDTAB_FNAME);
		res = let_user_edit_the_mountlist(mountlist, raidlist);
#ifdef __FreeBSD__
		system("mv -f /etc/raidtab /tmp/raidconf.txt");
#endif
		paranoid_MR_finish(res);
	}

	if (argc == 3 && strcmp(argv[1], "--echo-to-screen") == 0) {
		fout = fopen("/tmp/out.txt", "w");
		fput_string_one_char_at_a_time(stderr, argv[2]);
		finish(0);
	}

	if (argc == 3 && strcmp(argv[1], "--gendf") == 0) {
		make_grub_install_scriptlet(argv[2]);
		finish(0);
	}

	if (argc == 5 && strcmp(argv[1], "--common") == 0) {
		g_loglevel = 6;
		filelist = load_filelist(argv[2]);
		if (!filelist) {
			fatal_error("Failed to load filelist");
		}
		toggle_node_selection(filelist, FALSE);
		toggle_all_root_dirs_on(filelist);
		// BERLIOS: /usr/lib ???
		toggle_path_selection(filelist, "/usr/share", TRUE);
		save_filelist(filelist, "/tmp/out.txt");
		mr_asprintf(tmp1, "%s", argv[3]);
		mr_asprintf(tmp2, "%s", argv[4]);

		res = save_filelist_entries_in_common(tmp1, filelist, tmp2, FALSE);
		mr_free(tmp1);
		mr_free(tmp2);

		free_filelist(filelist);
		printf("res = %d", res);
		finish(0);
	}

	if (argc == 3 && strcmp(argv[1], "--popuplist") == 0) {
		popup_changelist_from_file(argv[2]);
		paranoid_MR_finish(0);
	}

	if (argc == 5 && strcmp(argv[1], "--copy") == 0) {
		log_msg(1, "SCORE");
		g_loglevel = 10;
		if (strstr(argv[2], "save")) {
			log_msg(1, "Saving from %s to %s", argv[3], argv[4]);
			fin = fopen(argv[3], "r");
			fout = fopen(argv[4], "w");
			copy_from_src_to_dest(fin, fout, 'w');
			fclose(fin);
			fin = fopen(argv[3], "r");
			copy_from_src_to_dest(fin, fout, 'w');
			fclose(fout);
			fclose(fin);
		} else if (strstr(argv[2], "restore")) {
			fout = fopen(argv[3], "w");
			fin = fopen(argv[4], "r");
			copy_from_src_to_dest(fout, fin, 'r');
			fclose(fin);
			fin = fopen(argv[4], "r");
			copy_from_src_to_dest(fout, fin, 'r');
			fclose(fout);
			fclose(fin);
		} else {
			fatal_error("Unknown additional param");
		}
		finish(0);
	}

	if (argc == 3 && strcmp(argv[1], "--mdstat") == 0) {
		wait_until_software_raids_are_prepped(argv[2], 100);
		finish(0);
	}

	if (argc == 3 && strcmp(argv[1], "--mdconv") == 0) {
		finish(create_raidtab_from_mdstat(argv[2]));
	}

	if (argc == 2 && strcmp(argv[1], "--live-grub") == 0) {
		retval = run_grub(FALSE, "/dev/hda");
		if (retval) {
			log_to_screen("Failed to write Master Boot Record");
		}
		paranoid_MR_finish(0);
	}
	if (argc == 3 && strcmp(argv[1], "--paa") == 0) {
		g_current_media_number = atoi(argv[2]);
		pause_and_ask_for_cdr(5, NULL);
		paranoid_MR_finish(0);
	}
	if ((argc == 2 && strcmp(argv[1], "--partition-only") == 0) && (bkpinfo->disaster_recovery)) {
		log_msg(0, "Partitioning only.");
		load_raidtab_into_raidlist(raidlist, RAIDTAB_FNAME);
		load_mountlist(mountlist, MINDI_CACHE"/mountlist.txt");
		res = partition_everything(mountlist);
		finish(res);
	}

	if ((argc == 2 && strcmp(argv[1], "--format-only") == 0) && (bkpinfo->disaster_recovery)) {
		log_msg(0, "Formatting only.");
		load_raidtab_into_raidlist(raidlist, RAIDTAB_FNAME);
		res = format_everything(mountlist, FALSE, raidlist);
		finish(res);
	}

	if ((argc == 2 && strcmp(argv[1], "--stop-lvm-and-raid") == 0) && (bkpinfo->disaster_recovery)) {
		log_msg(0, "Stopping LVM and RAID");
		load_raidtab_into_raidlist(raidlist, RAIDTAB_FNAME);
		load_mountlist(mountlist, MINDI_CACHE"/mountlist.txt");
		res = do_my_funky_lvm_stuff(TRUE, FALSE);
		res += stop_all_raid_devices(mountlist);
		finish(res);
	}

	// Handle params here first
	handle_incoming_parameters(argc,argv);

	if (!bkpinfo->disaster_recovery) {	// live!
		log_msg(1, "I am in normal, live mode.");
		mount_boot_if_necessary();	/* for Gentoo users */
		log_msg(2, "Still here.");
		/* Adding an initialisation in order to avoid to hndle NULL pointer later */
		mr_free(bkpinfo->restore_path);
		mr_asprintf(bkpinfo->restore_path, "%s", "/tmp");

		log_msg(2, "Calling restore_to_live_filesystem()");
		retval = restore_to_live_filesystem();

		log_msg(2, "Still here. Yay.");
		if ((strlen(bkpinfo->tmpdir) > 0) && (strstr(bkpinfo->tmpdir,"mondo.tmp.") != NULL)) {
			mr_asprintf(tmp, "rm -Rf %s/*", bkpinfo->tmpdir);
			run_program_and_log_output(tmp, FALSE);
			mr_free(tmp);
		}
		unmount_boot_if_necessary();	/* for Gentoo users */
		paranoid_MR_finish(retval);
	} else {
		/* Disaster recovery mode (must be) */
		log_msg(1, "I must be in disaster recovery mode.");

		log_it("About to call load_mountlist and load_raidtab");
		mr_free(bkpinfo->restore_path);
		mr_asprintf(bkpinfo->restore_path, "%s", MNT_RESTORING);
		read_cfg_file_into_bkpinfo(MINDI_CACHE"/mondorestore.cfg");
		retval = load_mountlist(mountlist, MINDI_CACHE"/mountlist.txt");
		retval += load_raidtab_into_raidlist(raidlist, RAIDTAB_FNAME);
		log_it("Returned from calling load_mountlist and load_raidtab successfully");

		// BCO:To be reviewed
		if ((bkpinfo->restore_mode == compare) || (bkpinfo->restore_mode == nuke)) {
			if ((bkpinfo->backup_media_type == netfs) && bkpinfo->netfs_mount && !is_this_device_mounted(bkpinfo->netfs_mount)) {
				log_msg(1, "Mounting remote %s dir", bkpinfo->netfs_proto);
				mr_free(bkpinfo->isodir);
				mr_asprintf(bkpinfo->isodir, "/tmp/isodir");
				run_program_and_log_output("mkdir -p /tmp/isodir", 5);
				if (strstr(bkpinfo->netfs_proto, "sshfs")) {
					if (bkpinfo->netfs_user) {
						mr_asprintf(tmp, "sshfs -o ro %s@%s /tmp/isodir", bkpinfo->netfs_user,bkpinfo->netfs_mount);
					} else {
						mr_asprintf(tmp, "sshfs -o ro %s /tmp/isodir", bkpinfo->netfs_mount);
					}
				} else {
					if (bkpinfo->netfs_user) {
						mr_asprintf(tmp, "mount %s@%s -o nolock,ro /tmp/isodir", bkpinfo->netfs_user,bkpinfo->netfs_mount);
					} else {
						mr_asprintf(tmp, "mount %s -o nolock,ro /tmp/isodir", bkpinfo->netfs_mount);
					}
				}
				run_program_and_log_output(tmp, 1);
				mr_free(tmp);
			}
		}

		if (retval) {
			log_to_screen("Warning - load_raidtab_into_raidlist returned an error");
		}

		log_msg(1, "Send in the clowns.");


		if (bkpinfo->restore_mode == nuke) {
			log_it("nuking");
			retval += nuke_mode(mountlist, raidlist);
		} else if (bkpinfo->restore_mode == interactive) {
			log_it("catchall");
			retval += catchall_mode(mountlist, raidlist);
		} else if (bkpinfo->restore_mode == compare) {
			log_it("compare");
			retval += compare_mode(mountlist, raidlist);
		} else if (bkpinfo->restore_mode == isoonly) {
			log_it("iso");
			retval = iso_mode(mountlist, raidlist, FALSE);
		} else if (bkpinfo->restore_mode == mbr) {
			log_it("mbr");
			retval = mount_all_devices(mountlist, TRUE);
			if (!retval) {
				retval += run_boot_loader(FALSE);
				retval += unmount_all_devices(mountlist);
			}
			if (retval) {
				log_to_screen("Failed to write Master Boot Record");
			}
		} else if (bkpinfo->restore_mode == isonuke) {
			log_it("isonuke");
			retval = iso_mode(mountlist, raidlist, TRUE);
		} else {
			log_it("catchall (no mode specified in command-line call");
			retval += catchall_mode(mountlist, raidlist);
		}
	}

	/* clean up at the end */
	if (retval) {
		if (does_file_exist(MONDO_CACHE"/changed.files")) {
			log_to_screen
				("See "MONDO_CACHE"/changed.files for list of files that have changed.");
		}
		mvaddstr_and_log_it(g_currentY++,
							0,
							"Run complete. Errors were reported. Please review the logfile.");
	} else {
		if (IS_THIS_A_STREAMING_BACKUP(bkpinfo->backup_media_type)) {
			mvaddstr_and_log_it(g_currentY++,
								0,
								"Run complete. Please remove media and reboot.");
		} else {
			sync();
			if (is_this_device_mounted(MNT_CDROM)) {
				run_program_and_log_output("umount " MNT_CDROM, FALSE);
			}

			if (!bkpinfo->please_dont_eject) {
				(void)eject_device("/dev/cdrom");
			}
			mvaddstr_and_log_it(g_currentY++,
								0,
								"Run complete. Please remove media and reboot.");
		}
	}

// g_I_have_just_nuked is set true by nuke_mode() just before it returns
	if (!system("which post-nuke > /dev/null 2> /dev/null")) {
	  log_msg(1, "post-nuke found; find out whether we should run it...");
	  if (g_I_have_just_nuked || does_file_exist("/POST-NUKE-ANYWAY")) {
	    run_postnuke = TRUE;
	    log_msg(1, "Yes, will run post-nuke because in nuke mode or file /POST-NUKE-ANYWAY exists.");
	  } else if (ask_me_yes_or_no("post-nuke script found. Do you want to run it?")) {
	    run_postnuke = TRUE;
	    log_msg(1, "Yes, will run post-nuke because user interactively asked for it.");
	  } else {
	    run_postnuke = FALSE;
	    log_msg(1, "No, will not run post-nuke.");
	  }
	} else {
	  log_msg(1, "No post-nuke found.");
	}
	if (run_postnuke) {
	  log_to_screen("Running post-nuke...");
	  if (mount_all_devices(mountlist, TRUE)) {
	    log_to_screen
	      ("Unable to re-mount partitions for post-nuke stuff");
	  } else {
	    log_msg(1, "Re-mounted partitions for post-nuke stuff");
	    mr_asprintf(tmp, "post-nuke %s %d", bkpinfo->restore_path, retval);
	    log_msg(2, "Calling '%s'", tmp);
	    if ((res = run_program_and_log_output(tmp, 0))) {
	      log_OS_error(tmp);
	    }
		mr_free(tmp);
	    log_msg(1, "post-nuke returned w/ res=%d", res);
	  }
	  unmount_all_devices(mountlist);
	  log_to_screen("I've finished post-nuking.");
	}

/*  
  log_to_screen("If you are REALLY in a hurry, hit Ctrl-Alt-Del now.");
  log_to_screen("Otherwise, please wait until the RAID disks are done.");
  wait_until_software_raids_are_prepped("/proc/mdstat", 100);
  log_to_screen("Thank you.");
*/
	unlink("/tmp/mondo-run-prog.tmp");
	set_signals(FALSE);
	log_to_screen("Restore log (%s) copied to /var/log on your hard disk", MONDO_LOGFILE);
	log_to_screen("Mondo-restore is exiting (retval=%d)                                      ", retval);

	mr_asprintf(tmp, "umount %s", bkpinfo->isodir);
	run_program_and_log_output(tmp, 5);
	mr_free(tmp);

	paranoid_free(mountlist);
	paranoid_free(raidlist);
	if (am_I_in_disaster_recovery_mode()) {
		run_program_and_log_output("mount / -o remount,rw", 2);
	}							// for b0rken distros
	if (strstr(bkpinfo->tmpdir,"mondo.tmp.") != NULL) {
		mr_asprintf(tmp, "rm -Rf %s", bkpinfo->tmpdir);
		system(tmp);
		mr_free(tmp);
	}
	paranoid_MR_finish(retval);	// frees global stuff plus bkpinfo
	free_libmondo_global_strings();	// it's fine to have this here :) really :)

	unlink("/tmp/filelist.full");

	exit(retval);
}

/**************************************************************************
 *END_MAIN                                                                *
 **************************************************************************/





/**************************************************************************
 *END_MONDO-RESTORE.C                                                     *
 **************************************************************************/
