#!/usr/bin/perl -w
#
# Subroutines brought by the MondoRescue project to do HW/FW/SW inventory
#
# $Id$
#
# Copyright B. Cornec 2008
# Provided under the GPL v2

package MondoRescue::Inventory;

use strict 'vars';
use Data::Dumper;
use English;
use File::Basename;
use File::Copy;
use POSIX qw(strftime);
use lib qw (lib);
use ProjectBuilder::Base;
use ProjectBuilder::Conf;
use ProjectBuilder::Distribution;
use MondoRescue::LVM;
use MondoRescue::Kernel;

# Inherit from the "Exporter" module which handles exporting functions.

use Exporter;

# Export, by default, all the functions into the namespace of
# any code which uses this module.

our @ISA = qw(Exporter);
our @EXPORT = qw(mr_inv_os $mr_os);

# Globals
our %mr_hw;
our $mr_hw = \%mr_hw;
our %mr_os;
our $mr_os = \%mr_hw;

=pod

=head1 NAME

MondoRescue::Inventory, part of the mondorescue.org

=head1 DESCRIPTION

This modules provides inventory functions for the Mondorescue project in order to report
the precise context of the system to be archived (Hardware, Firmware and Software as much as possible)
This module aims to be OS independent

=head1 USAGE

=over 4

=item B<mr_inv_hw>

This function reports Hardware inventory of the system to archive

=cut

sub mr_inv_hw {
	
	# Keyboard
	# Raid SW - DM
	# Partitions
	# FS/swaps
	# LVM / ...
	# PCI / USB / lssd / ...
	# messages/dmesg
	# Kernel / Initrd
	# Kernel Modules
	# cmdline
}

sub mr_inv_os {

($mr_os->{'name'}, $mr_os->{'version'}, $mr_os->{'family'}, $mr_os->{'type'}, $mr_os->{'os'}, $mr_os->{'suffix'}, $mr_os->{'update'}, $mr_os->{'arch'}) = pb_distro_init();

# Get some conf file content when they exist; Depends on genre or more precise tuple
for my $p ("mr_cmdline","mr_fstab","mr_raidtab","mr_swap","mr_partitions","mr_filesystems","mr_modules","mr_xen") {
	my $key = $p;
	$key =~ s/mr_//;
	my ($pp) = pb_conf_get_if($p);
	if (defined $pp) {
		my $file = pb_distro_get_param($mr_os->{'name'},$mr_os->{'version'},$mr_os->{'arch'},$pp,$mr_os->{'family'},$mr_os->{'type'},$mr_os->{'os'});
		if (-r $file) {
			pb_log(2,"DEBUG: File found: $file\n");
			$mr_os->{'files'}->{$key} = pb_get_content($file);
		} else {
			pb_log(2,"WARNING: $file not found\n");
		}
	}
}

# Get some commands result content when they exist; Depends on genre or more precise tuple
for my $p ("mr_mount","mr_lsmod","mr_df") {
	my $key = $p;
	$key =~ s/mr_//;
	my ($pp) = pb_conf_get_if($p);
	if (defined $pp) {
		my $cmd = pb_distro_get_param($mr_os->{'name'},$mr_os->{'version'},$mr_os->{'arch'},$pp,$mr_os->{'family'},$mr_os->{'type'},$mr_os->{'os'});
		pb_log(2,"DEBUG: Cmd found: $cmd\n");
		$mr_os->{'cmd'}->{$key} = `$cmd`;
	}
}
# 
# LVM setup
#
($mr_os->{'lvmver'},$mr_os->{'$lvmcmd'}) = mr_lvm_check();

# Summary of conf printed.
pb_log(1,"OS Inventory: ".Dumper($mr_os)."\n");
}

=item B<mr_inv_fw>

This function reports Firmware inventory of the system to archive

=cut

sub mr_inv_fw {

	# Linked to bkphw
	# On Proliant use hpacucli, conrep, hponcfg
}

=item B<mr_inv_sw>

This function reports Software inventory of the system to archive

=cut

sub mr_inv_sw {

	# Commands presence - use FindBin
	# deplist
	# mountlist
}
