#include <mr_mem.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

void (*mr_cleanup)(void) = NULL;

void is_null(const char* str)
{
  if (str == NULL)
        printf("pointer is null\n");
  else
        printf("pointer is NOT null\n");
}

int main(void)
{
  char* str = NULL;

  printf("*** Test with mr_free\n");
  str = mr_malloc(10);
  is_null(str);
  mr_free(str);
  is_null(str);

  printf("*** Test with NULL\n");
  str = NULL;
  is_null(str);
  mr_free(str);
  is_null(str);

  mr_asprintf(&str, "%s is %d", "two", 2);
  printf("*** String is %s\n",str);

  /* Cating other content */
  mr_strcat(str," But %s is %d", "three", 3);
  printf("*** String is now %s\n",str);

  exit(0);
}

