/*
 * Test file to test the configuration file handling
 *
 * $Id$
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "mr_conf.h"
#include "mr_mem.h"

int g_main_pid = 0;
int g_buffer_pid = 0;

void (*mr_cleanup)(void) = NULL;

int main(void) {
	int ret = 0;
	char *s = NULL;
	
	if ((ret = mr_conf_open("mondo.conf")) != 0) {
		fprintf(stderr,"Unable to open conf file (%d)\n",ret); 
		exit(-1);
	}
	s = mr_conf_iread("testinteger");
	if (s == NULL) {
		fprintf(stderr,"Unable to get integer\n");
		exit(-1);
	}
	fprintf(stdout, "Integer : ***%d***\n",atoi(s));
	mr_free(s);

	s = mr_conf_fread("testfloat");
	if (s == NULL) {
		fprintf(stderr,"Unable to get float\n");
		exit(-1);
	}
	fprintf(stdout, "Float : ***%f***\n",atof(s));
	mr_free(s);

	s = mr_conf_sread("teststring");
	if (s == NULL) {
		fprintf(stderr,"Unable to get string\n");
		exit(-1);
	}
	fprintf(stdout, "String : ***%s***\n",s);
	mr_free(s);

	mr_conf_close();
	exit(ret);
}
