/*
 * $Id$
 *
 * Test program for mountlist management at restore time
 * Cn be used on host system with valgrind easier than with mondorestore
 */
#include <stdio.h>
#include "my-stuff.h"
#include "mr_mem.h"
#include "../common/mondostructures.h"
#include "../common/libmondo.h"
#include "../mondoarchive/mondoarchive.h"

extern void twenty_seconds_til_yikes(void);

/* Reference to global bkpinfo */
struct s_bkpinfo *bkpinfo;

extern bool g_text_mode;
extern FILE *g_fprep;
extern double g_kernel_version;
extern int g_partition_table_locked_up;
extern int g_noof_rows;

bool g_ISO_restore_mode = FALSE;	/* are we in Iso Mode? */
bool g_I_have_just_nuked = FALSE;
char *g_isodir_device;
char *g_isodir_format;
char *g_biggielist_txt;
char *g_filelist_full;
char *g_filelist_imagedevs;
char *g_imagedevs_restthese;

char *g_mondo_cfg_file;

char *g_mountlist_fname;
char *g_mondo_home;

char *g_getfacl;
char *g_getfattr;

extern char *MONDO_LOGFILE;
extern char *truncate_to_drive_name(char *);
/* We don't have a cleanup function yet */
void (*mr_cleanup)(void) = NULL;
void free_MR_global_filenames() {
}

void main() {

char *part = NULL;
char *disk = NULL;
char *list[] = {
		"/dev/sda99",
		"/dev/hda12",
		"/dev/cciss/c12d9p24",
		"/dev/mapper/vg00lv02",
		"/dev/mapper/dm-4",
		"/dev/mapper/mpath4p19",
		"/dev/mapper/part13",
		"/dev/rd/c10d4p16",
		"/dev/cciss/c1d12",
		"/dev/mapper/mpath34",
		"",
		NULL
};
int i;

mr_asprintf(&MONDO_LOGFILE,"/tmp/mrtest-truncname.log");

/* Globals */
g_loglevel = 99;
g_text_mode = FALSE;
g_main_pid = getpid();

log_it("Begin loop");
for (i=0; list[i] != NULL; i++) {
	log_it("%d: partition %s ...",i, list[i]);
	mr_asprintf(&part,"%s",list[i]);
	disk = truncate_to_drive_name(part);
	log_it(" belongs to disk %s",disk);
	mr_free(part);
}
log_it("end of loop");
mr_free(MONDO_LOGFILE);
exit(0);
}
