#
# Project Builder configuration file
# For project mondorescue
#
# $Id$
#

#
# Which CMS system is used
#
cms mondorescue = svn

#
# Packager label
#
packager mondorescue = "Bruno Cornec <bruno@mondorescue.org>"

#
# For delivery to a machine by SSH (potentially the FTP server)
# Needs hostname, account and directory
#
sshhost mondorescue = www.mondorescue.org
sshlogin mondorescue = bruno
sshdir mondorescue = /mondo/ftp
sshport mondorescue = 22

#
# For Virtual machines management
# Naming convention to follow: distribution name (as per ProjectBuilder::Distribution)
# followed by '_' and by release number
# a .vmtype extension will be added to the resulting string
# a QEMU rhel_3 here means that the VM will be named rhel_3.qemu
#
vmlist mondorescue = mandrake_10.1,mandrake_10.2,mandriva_2006.0,mandriva_2007.0,mandriva_2007.1,mandriva_2008.0,redhat_7.3,redhat_9,fedora_4,fedora_5,fedora_6,fedora_7,rhel_2.1,rhel_3,rhel_4,rhel_5,suse_10.0,suse_10.1,suse_10.2,suse_10.3,sles_9,sles_10,debian_3.1,debian_4.0,ubuntu_6.06,ubuntu_7.04,ubuntu_7.10,gentoo_nover,slackware_10.2,slackware_11.0,freebsd_5.5

#
# Valid values for vmtype are
# qemu, (vmware, xen, ... TBD)
vmtype mondorescue = qemu
vmntp mondorescue = pool.ntp.org

# We suppose we can commmunicate with the VM through SSH
vmhost mondorescue = localhost
vmlogin mondorescue = pb
vmport mondorescue = 2222
# Timeout to wait when VM is launched/stopped
vmtmout default = 120

vmsize mondorescue = 5G

# per VMs needed paramaters
#vmopt mondorescue = -m 256 -nographic -daemonize
vmopt mondorescue = -m 384 -daemonize
vmpath mondorescue = /users/qemu

projver mondorescue = 2.2.5
projtag mondorescue = 1

# Hash of default package/package directory
defpkgdir mondo = mondo
defpkgdir mindi = mindi

pkgver mindi = 2.0.0
pkgver mindi-busybox = 1.7.3
#pkgtag mindi-busybox = 2

# Hash of additional package/package directory
extpkgdir mindi-busybox = mindi-busybox
extpkgdir mondo-doc = mondo-doc

# Hash of valid version names
version devel
version stable

# List of additional files on which to apply filters
# Files are mentioned relatively to pbroot
filteredfiles mondo = configure.in
filteredfiles mondo-doc = mondorescue-howto.sgml,mondoarchive.8,mondorestore.8,mindi.8
filteredfiles mindi = rootfs/sbin/init,mindi,install.sh
filteredfiles mindi-busybox = Makefile
filteredfiles mondo-website = top.shtml
