/* libmondo-fork.c - subroutines for handling forking/pthreads/etc.
 * $Id: libmondo-fork.c 1609 2007-08-31 22:07:44Z bruno $
 */
#include "my-stuff.h"
#include "mr_mem.h"
#include "mr_msg.h"
#include "mr_str.h"
#include "mr_gettext.h"

#include "mondostructures.h"
#include "libmondo-fork.h"
#include "libmondo-string-EXT.h"
#include "newt-specific-EXT.h"
#include "libmondo-files-EXT.h"
#include "libmondo-tools-EXT.h"

/*@unused@*/
//static char cvsid[] = "$Id: libmondo-fork.c 1609 2007-08-31 22:07:44Z bruno $";

extern char *g_tmpfs_mountpt;
extern t_bkptype g_backup_media_type;
extern bool g_text_mode;
extern char *MONDO_LOGFILE;
pid_t g_buffer_pid = 0;


/**
 * Call a program and retrieve its last line of output.
 * @param call The program to run.
 * @return The last line of its output.
 * @note The returned value points to static storage that will be overwritten with each call.
 */
char *call_program_and_get_last_line_of_output(char *call)
{
	/*@ buffers ***************************************************** */
	static char result[512];
	char *tmp;

	/*@ pointers **************************************************** */
	FILE *fin;

	/*@ initialize data ********************************************* */
	malloc_string(tmp);
	result[0] = '\0';
	tmp[0] = '\0';

	/*@******************************************************************** */

	assert_string_is_neither_NULL_nor_zerolength(call);

	if ((fin = popen(call, "r"))) {
		for (fgets(tmp, MAX_STR_LEN, fin); !feof(fin);
			 fgets(tmp, MAX_STR_LEN, fin)) {
			if (strlen(tmp) > 1) {
				strcpy(result, tmp);
			}
		}
		paranoid_pclose(fin);
	} else {
		log_OS_error("Unable to popen call");
	}
	mr_strip_spaces(result);
	mr_free(tmp);
	return (result);
}






#define MONDO_POPMSG  "Your PC will not retract the CD tray automatically. Please call mondoarchive with the -m (manual CD tray) flag."

/**
 * Call mkisofs to create an ISO image.
 * @param bkpinfo The backup information structure. Fields used:
 * - @c bkpinfo->manual_tray
 * - @c bkpinfo->backup_media_type
 * - @c bkpinfo->please_dont_eject_when_restoring
 * @param basic_call The call to mkisofs. May contain tokens that will be resolved to actual data. The tokens are:
 * - @c _ISO_ will become the ISO file (@p isofile)
 * - @c _CD#_ becomes the CD number (@p cd_no)
 * - @c _ERR_ becomes the logfile (@p g_logfile)
 * @param isofile Replaces @c _ISO_ in @p basic_call. Should probably be the ISO image to create (-o parameter to mkisofs).
 * @param cd_no Replaces @c _CD#_ in @p basic_call. Should probably be the CD number.
 * @param logstub Unused.
 * @param what_i_am_doing The action taking place (e.g. "Making ISO #1"). Used as the title of the progress dialog.
 * @return Exit code of @c mkisofs (0 is success, anything else indicates failure).
 * @bug @p logstub is unused.
 */
int
eval_call_to_make_ISO(struct s_bkpinfo *bkpinfo,
					  char *basic_call, char *isofile,
					  int cd_no, char *logstub, char *what_i_am_doing)
{

	/*@ int's  *** */
	int retval = 0;


	/*@ buffers      *** */
	char *ultimate_call;
	char *midway_call;
	char *p = NULL;	
	char *cd_number_str = NULL;
	char *command = NULL;
	

/*@***********   End Variables ***************************************/

	mr_msg(3, "Starting");
	assert(bkpinfo != NULL);
	// BERLIOS: doesn't work even if the string is correct !
	//assert_string_is_neither_NULL_nor_zerolength(basic_call);
	assert_string_is_neither_NULL_nor_zerolength(isofile);
	assert_string_is_neither_NULL_nor_zerolength(logstub);

	ultimate_call = mr_malloc(1200);
	midway_call = mr_malloc(1200);

	mr_msg(5,"isofile: %s - cd_number_str: %d", isofile, cd_number_str);
	mr_asprintf(&cd_number_str, "%d", cd_no);
	resolve_naff_tokens(midway_call, basic_call, isofile, "_ISO_");
	resolve_naff_tokens(ultimate_call, midway_call, cd_number_str, "_CD#_");
	mr_free(cd_number_str);

	mr_msg(4, "basic call = '%s'", basic_call);
	mr_msg(4, "midway call = '%s'", midway_call);
	mr_msg(4, "ultimate call = '%s'", ultimate_call);
	mr_asprintf(&command, "%s >> %s", ultimate_call, MONDO_LOGFILE);

	log_to_screen
		(_("Please be patient. Do not be alarmed by on-screen inactivity."));
	mr_msg(4, "Calling open_evalcall_form() with what_i_am_doing='%s'",
			what_i_am_doing);
	if (bkpinfo->manual_tray) {
		/* Find everything after a 2>> and remove it */
		p = strstr(command, "2>>");
		if (p) {
			for (; *p != ' ' && *p != '\0'; p++) {
				*p = ' ';
			}
		}
#ifndef _XWIN
		if (!g_text_mode) {
			newtSuspend();
		}
#endif
		mr_msg(1, "command = '%s'", command);
		retval += system(command);
		if (!g_text_mode) {
			newtResume();
		}
		if (retval) {
			mr_msg(2, "Ultimate call '%s' returned an error.", ultimate_call);
			popup_and_OK(_("Press ENTER to continue."));
			popup_and_OK
				(_("CD was not created due to an error."));
		}
	}
	/* if text mode then do the above & RETURN; if not text mode, do this... */
	else {
		mr_msg(3, "command = '%s'", command);
//      yes_this_is_a_goto:
		retval =
			run_external_binary_with_percentage_indicator_NEW
			(what_i_am_doing, command);
	}
	mr_free(command);

	mr_free(midway_call);
	mr_free(ultimate_call);
	return (retval);
}


/**
 * Run a program and log its output (stdout and stderr) to the logfile.
 * @param program The program to run. Passed to the shell, so you can use pipes etc.
 * @param debug_level If @p g_loglevel is higher than this, do not log the output.
 * @return The exit code of @p program (depends on the command, but 0 almost always indicates success).
 */
int run_program_and_log_output(char *program, int debug_level)
{
	/*@ buffer ****************************************************** */
	char *callstr = NULL;
	char *incoming = NULL;

	/*@ int ********************************************************* */
	int res = 0;
	size_t n = 0;
	bool log_if_failure = FALSE;
	bool log_if_success = FALSE;

	/*@ pointers *************************************************** */
	FILE *fin = NULL;
	char *p = NULL;

	/*@ end vars *************************************************** */

	assert(program != NULL);
	if (!program[0]) {
		mr_msg(2, "Warning - asked to run zerolength program");
		return (1);
	}

	if (debug_level <= g_loglevel) {
		log_if_success = TRUE;
		log_if_failure = TRUE;
	}
	mr_asprintf(&callstr,
			"%s > /tmp/mondo-run-prog-thing.tmp 2> /tmp/mondo-run-prog-thing.err",
			program);
	while ((p = strchr(callstr, '\r'))) {
		*p = ' ';
	}
	while ((p = strchr(callstr, '\n'))) {
		*p = ' ';
	}							/* single '=' is intentional */

	res = system(callstr);
	if (((res == 0) && log_if_success) || ((res != 0) && log_if_failure)) {
		mr_msg(0, "running: %s", callstr);
		mr_msg(0,
				"--------------------------------start of output-----------------------------");
	}
	mr_free(callstr);

	if (log_if_failure
		&&
		system
		("cat /tmp/mondo-run-prog-thing.err >> /tmp/mondo-run-prog-thing.tmp 2> /dev/null"))
	{
		log_OS_error("Command failed");
	}
	unlink("/tmp/mondo-run-prog-thing.err");
	fin = fopen("/tmp/mondo-run-prog-thing.tmp", "r");
	if (fin) {
		for (mr_getline(&incoming, &n, fin); !feof(fin); mr_getline(&incoming, &n, fin)) {
			/* Suppress % so they are not interpreted in mr_msg */
			while ((p = strchr(incoming, '%'))) {
				*p = ' ';
			}
			mr_strip_spaces(incoming);
			if ((res == 0 && log_if_success)
				|| (res != 0 && log_if_failure)) {
				mr_msg(0, incoming);
			}
		}
		mr_free(incoming);
		paranoid_fclose(fin);
	}
	unlink("/tmp/mondo-run-prog-thing.tmp");
	if ((res == 0 && log_if_success) || (res != 0 && log_if_failure)) {
		mr_msg(0,
				"--------------------------------end of output------------------------------");
		if (res) {
			mr_msg(0, "...ran with res=%d", res);
		} else {
			mr_msg(0, "...ran just fine. :-)");
		}
	}
	return (res);
}


/**
 * Run a program and log its output to the screen.
 * @param basic_call The program to run.
 * @param what_i_am_doing The title of the evalcall form.
 * @return The return value of the command (varies, but 0 almost always means success).
 * @see run_program_and_log_output
 * @see log_to_screen
 */
int run_program_and_log_to_screen(char *basic_call, char *what_i_am_doing)
{
	/*@ int ******************************************************** */
	int retval = 0;
	int res = 0;
	int i;

	/*@ pointers **************************************************** */
	FILE *fin;

	/*@ buffers **************************************************** */
	char *tmp = NULL;
	char *command = NULL;
	char *lockfile = NULL;

	/*@ end vars *************************************************** */

	assert_string_is_neither_NULL_nor_zerolength(basic_call);

	mr_asprintf(&lockfile, "/tmp/mojo-jojo.blah.XXXXXX");
	mkstemp(lockfile);
	mr_asprintf(&command,
			"echo hi > %s ; %s >> %s 2>> %s; res=$?; sleep 1; rm -f %s; exit $res",
			lockfile, basic_call, MONDO_LOGFILE, MONDO_LOGFILE, lockfile);
	open_evalcall_form(what_i_am_doing);
	mr_asprintf(&tmp, "Executing %s", basic_call);
	mr_msg(2, tmp);
	mr_free(tmp);

	if (!(fin = popen(command, "r"))) {
		log_OS_error("Unable to popen-in command");
		mr_asprintf(&tmp, _("Failed utterly to call '%s'"), command);
		log_to_screen(tmp);
		mr_free(tmp);
		mr_free(lockfile);
		mr_free(command);
		return (1);
	}
	mr_free(command);

	if (!does_file_exist(lockfile)) {
		log_to_screen(_("Waiting for external binary to start"));
		for (i = 0; i < 60 && !does_file_exist(lockfile); sleep(1), i++) {
			mr_msg(3, "Waiting for lockfile %s to exist", lockfile);
		}
	}
	/* This works on Newt, and it gives quicker updates. */
	for (; does_file_exist(lockfile); sleep(1)) {
		log_file_end_to_screen(MONDO_LOGFILE, "");
		update_evalcall_form(1);
	}
	/* Evaluate the status returned by pclose to get the exit code of the called program. */
	errno = 0;
	res = pclose(fin);
	/* Log actual pclose errors. */
	if (errno) {
		mr_msg(5, "pclose err: %d", errno);
	}
	/* Check if we have a valid status. If we do, extract the called program's exit code. */
	/* If we don't, highlight this fact by returning -1. */
	if (WIFEXITED(res)) {
		retval = WEXITSTATUS(res);
	} else {
		retval = -1;
	}
	close_evalcall_form();
	unlink(lockfile);
	mr_free(lockfile);

	return (retval);
}


/**
 * Apparently used. @bug This has a purpose, but what?
 */
#define PIMP_START_SZ "STARTSTARTSTART9ff3kff9a82gv34r7fghbkaBBC2T231hc81h42vws8"
#define PIMP_END_SZ "ENDENDEND0xBBC10xBBC2T231hc81h42vws89ff3kff9a82gv34r7fghbka"




int copy_from_src_to_dest(FILE * f_orig, FILE * f_archived, char direction)
{
// if dir=='w' then copy from orig to archived
// if dir=='r' then copy from archived to orig
	char *tmp = NULL;
	char *tmp1 = NULL;
	char *buf = NULL;
	long int bytes_to_be_read, bytes_read_in, bytes_written_out =
		0, bufcap, subsliceno = 0;
	int retval = 0;
	FILE *fin = NULL;
	FILE *fout = NULL;
	FILE *ftmp = NULL;

	mr_msg(5, "Opening.");
	malloc_string(tmp);
	tmp[0] = '\0';
	bufcap = 256L * 1024L;
	buf = mr_malloc(bufcap);

	if (direction == 'w') {
		fin = f_orig;
		fout = f_archived;
		mr_asprintf(&tmp1, "%-64s", PIMP_START_SZ);
		if (fwrite(tmp1, 1, 64, fout) != 64) {
			fatal_error("Can't write the introductory block");
		}
		mr_free(tmp1);

		while (1) {
			bytes_to_be_read = bytes_read_in = fread(buf, 1, bufcap, fin);
			if (bytes_read_in == 0) {
				break;
			}
			mr_asprintf(&tmp1, "%-64ld", bytes_read_in);
			if (fwrite(tmp1, 1, 64, fout) != 64) {
				fatal_error("Cannot write introductory block");
			}
			mr_free(tmp1);

			mr_msg(7,
					"subslice #%ld --- I have read %ld of %ld bytes in from f_orig",
					subsliceno, bytes_read_in, bytes_to_be_read);
			bytes_written_out += fwrite(buf, 1, bytes_read_in, fout);
			mr_asprintf(&tmp1, "%-64ld", subsliceno);
			if (fwrite(tmp1, 1, 64, fout) != 64) {
				fatal_error("Cannot write post-thingy block");
			}
			mr_free(tmp1);

			mr_msg(7, "Subslice #%d written OK", subsliceno);
			subsliceno++;
		}
		sprintf(tmp, "%-64ld", 0L);
		if (fwrite(tmp, 1, 64L, fout) != 64L) {
			fatal_error("Cannot write final introductory block");
		}
	} else {
		fin = f_archived;
		fout = f_orig;
		tmp = mr_malloc(64L);
		if (fread(tmp, 1, 64L, fin) != 64L) {
			fatal_error("Cannot read the introductory block");
		}
		mr_msg(5, "tmp is %s", tmp);
		if (!strstr(tmp, PIMP_START_SZ)) {
			fatal_error("Can't find intro blk");
		}
		if (fread(tmp, 1, 64L, fin) != 64L) {
			fatal_error("Cannot read introductory blk");
		}
		bytes_to_be_read = atol(tmp);
		while (bytes_to_be_read > 0) {
			mr_msg(7, "subslice#%ld, bytes=%ld", subsliceno,
					bytes_to_be_read);
			bytes_read_in = fread(buf, 1, bytes_to_be_read, fin);
			if (bytes_read_in != bytes_to_be_read) {
				fatal_error
					("Danger, WIll Robinson. Failed to read whole subvol from archives.");
			}
			bytes_written_out += fwrite(buf, 1, bytes_read_in, fout);
			if (fread(tmp, 1, 64L, fin) != 64L) {
				fatal_error("Cannot read post-thingy block");
			}
			if (atol(tmp) != subsliceno) {
				mr_msg(1, "Wanted subslice %ld but got %ld ('%s')",
						subsliceno, atol(tmp), tmp);
			}
			mr_msg(7, "Subslice #%ld read OK", subsliceno);
			subsliceno++;
			if (fread(tmp, 1, 64L, fin) != 64L) {
				fatal_error("Cannot read introductory block");
			}
			bytes_to_be_read = atol(tmp);
		}
	}

//  mr_msg(4, "Written %ld of %ld bytes", bytes_written_out, bytes_read_in);

	if (direction == 'w') {
		mr_asprintf(&tmp1, "%-64s", PIMP_END_SZ);
		if (fwrite(tmp1, 1, 64L, fout) != 64L) {
			fatal_error("Can't write the final block");
		}
		mr_free(tmp1);
	} else {
		mr_msg(1, "tmpA is %s", tmp);
		if (!strstr(tmp, PIMP_END_SZ)) {
			if (fread(tmp, 1, 64L, fin) != 64L) {
				fatal_error("Can't read the final block");
			}
			mr_msg(5, "tmpB is %s", tmp);
			if (!strstr(tmp, PIMP_END_SZ)) {
				ftmp = fopen("/tmp/out.leftover", "w");
				bytes_read_in = fread(tmp, 1, 64L, fin);
				mr_msg(1, "bytes_read_in = %ld", bytes_read_in);
//      if (bytes_read_in!=128+64) { fatal_error("Can't read the terminating block"); }
				fwrite(tmp, 1, bytes_read_in, ftmp);
				sprintf(tmp, "I am here - %lld", (long long)ftello(fin));
//    mr_msg(0, tmp);
				fread(tmp, 1, 512, fin);
				mr_msg(0, "tmp = '%s'", tmp);
				fwrite(tmp, 1, 512, ftmp);
				fclose(ftmp);
				fatal_error("Missing terminating block");
			}
		}
	}

	mr_free(buf);
	mr_free(tmp);
	mr_msg(3, "Successfully copied %ld bytes", bytes_written_out);
	return (retval);
}

/**
 * Feed @p input_device through ntfsclone to @p output_fname.
 * @param input_device The device to image.
 * @param output_fname The file to write.
 * @return 0 for success, nonzero for failure.
 */
int feed_into_ntfsprog(char *input_device, char *output_fname)
{
// BACKUP
	int res = -1;
	char *command = NULL;

	if (!does_file_exist(input_device)) {
		fatal_error("input device does not exist");
	}
	if ( !find_home_of_exe("ntfsclone")) {
		fatal_error("ntfsclone not found");
	}
	mr_asprintf(&command, "ntfsclone --force --save-image --overwrite %s %s", output_fname, input_device);
	res = run_program_and_log_output(command, 5);
	mr_free(command);

	unlink(output_fname);
	return (res);
}


int run_external_binary_with_percentage_indicator_OLD(char *tt, char *cmd)
{

	int res = 0;
	int percentage = 0;
	int maxpc = 0;
	int pcno = 0;
	int last_pcno = 0;

	char *command = NULL;
	char *tempfile;
	char *title;
	/*@ pointers ********************************************************** */
	FILE *pin;

	malloc_string(title);
	malloc_string(tempfile);
	assert_string_is_neither_NULL_nor_zerolength(cmd);
	assert_string_is_neither_NULL_nor_zerolength(title);

	strcpy(title, tt);
	strcpy(tempfile,
		   call_program_and_get_last_line_of_output
		   ("mktemp -q /tmp/mondo.XXXXXXXX"));
	mr_asprintf(&command, "%s >> %s 2>> %s; rm -f %s", cmd, tempfile, tempfile,
			tempfile);
	mr_msg(3, command);
	open_evalcall_form(title);
	if (!(pin = popen(command, "r"))) {
		log_OS_error("fmt err");
		mr_free(command);
		return (1);
	}
	mr_free(command);

	maxpc = 100;
// OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD
	for (sleep(1); does_file_exist(tempfile); sleep(1)) {
		pcno = grab_percentage_from_last_line_of_file(MONDO_LOGFILE);
		if (pcno < 0 || pcno > 100) {
			mr_msg(5, "Weird pc#");
			continue;
		}
		percentage = pcno * 100 / maxpc;
		if (pcno <= 5 && last_pcno > 40) {
			close_evalcall_form();
			strcpy(title, "Verifying...");
			open_evalcall_form(title);
		}
		last_pcno = pcno;
		update_evalcall_form(percentage);
	}
// OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD OLD
	close_evalcall_form();
	if (pclose(pin)) {
		res++;
		log_OS_error("Unable to pclose");
	}
	unlink(tempfile);
	mr_free(tempfile);
	mr_free(title);
	return (res);
}


void *run_prog_in_bkgd_then_exit(void *info)
{
	char *sz_command;
	static int res = 4444;

	res = 999;
	sz_command = (char *) info;
	mr_msg(4, "sz_command = '%s'", sz_command);
	res = system(sz_command);
	if (res > 256 && res != 4444) {
		res = res / 256;
	}
	mr_msg(4, "child res = %d", res);
	sz_command[0] = '\0';
	pthread_exit((void *) (&res));
}


int run_external_binary_with_percentage_indicator_NEW(char *tt, char *cmd)
{

	/*@ int *************************************************************** */
	int res = 0;
	int percentage = 0;
	int maxpc = 100;
	int pcno = 0;
	int last_pcno = 0;
	int counter = 0;

	/*@ buffers *********************************************************** */
	char *command = NULL;
	char *title;
	/*@ pointers ********************************************************** */
	static int chldres = 0;
	int *pchild_result;
	pthread_t childthread;

	pchild_result = &chldres;
	assert_string_is_neither_NULL_nor_zerolength(cmd);
	assert_string_is_neither_NULL_nor_zerolength(tt);
	*pchild_result = 999;

	malloc_string(title);
	strcpy(title, tt);
	mr_asprintf(&command, "%s 2>> %s", cmd, MONDO_LOGFILE);
	mr_msg(3, "command = '%s'", command);
	if ((res =
		 pthread_create(&childthread, NULL, run_prog_in_bkgd_then_exit,
						(void *) command))) {
		fatal_error("Unable to create an archival thread");
	}

	mr_msg(8, "Parent running");
	open_evalcall_form(title);
	for (sleep(1); command[0] != '\0'; sleep(1)) {
		pcno = grab_percentage_from_last_line_of_file(MONDO_LOGFILE);
		if (pcno <= 0 || pcno > 100) {
			mr_msg(8, "Weird pc#");
			continue;
		}
		percentage = pcno * 100 / maxpc;
		if (pcno <= 5 && last_pcno >= 40) {
			close_evalcall_form();
			strcpy(title, "Verifying...");
			open_evalcall_form(title);
		}
		if (counter++ >= 5) {
			counter = 0;
			log_file_end_to_screen(MONDO_LOGFILE, "");
		}
		last_pcno = pcno;
		update_evalcall_form(percentage);
	}
	mr_free(command);

	log_file_end_to_screen(MONDO_LOGFILE, "");
	close_evalcall_form();
	pthread_join(childthread, (void *) (&pchild_result));
	if (pchild_result) {
		res = *pchild_result;
	} else {
		res = 666;
	}
	mr_msg(3, "Parent res = %d", res);
	mr_free(title);
	return (res);
}


/**
 * Feed @p input_fifo through ntfsclone (restore) to @p output_device.
 * @param input_fifo The ntfsclone file to read.
 * @param output_device Where to put the output.
 * @return The return value of ntfsclone (0 for success).
 */
int feed_outfrom_ntfsprog(char *output_device, char *input_fifo)
{
// RESTORE
	int res = -1;
	char *command = NULL;

	if ( !find_home_of_exe("ntfsclone")) {
		fatal_error("ntfsclone not found");
	}
	mr_asprintf(&command, "ntfsclone --force --restore-image --overwrite %s %s", output_device, input_fifo);
	res = run_program_and_log_output(command, 5);
	mr_free(command);
	return (res);
}
