/*
 * Test file to test the configuration file handling
 *
 * $Id$
 *
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "mr_str.h"
#include "mr_mem.h"

void (*mr_cleanup)(void) = NULL;

int main(void) {
	const char delims[3] = ": \n";
	
	int  lastpos = 0;
	char *token  = NULL;
	char *string = NULL;

	mr_asprintf(&string, "md0 : active raid10 hda1[0] hda12[3] hda6[2] hda5[1]\n");
	fprintf(stdout, "string=|%s|\n", string);
	while ((token = mr_strtok(string, delims, &lastpos))) {
		fprintf(stdout, "token=|%s|, lastpos=%d\n", token, lastpos);
		mr_free(token);
	}
	mr_free(string);

	mr_asprintf(&string, " 	 This is a chain with spaces before and behind  	");
	fprintf(stdout, "string=|%s|\n", string);
	mr_strip_spaces(string);
	fprintf(stdout, "string=|%s|\n", string);
	mr_free(string);
	mr_asprintf(&string, "This is a chain without spaces before and behind");
	fprintf(stdout, "string=|%s|\n", string);
	mr_strip_spaces(string);
	fprintf(stdout, "string=|%s|\n", string);
	mr_free(string);

	exit(0);
}
