/*
 * $Id$
 *
 *     Header file of mr_list.c: a set of function manipulating lists
 *     Provided under the GPL v2
 */

#ifndef MR_LIST_H
#define MR_LIST_H

/* Data structure */
struct mr_list {
	/**
	 * Pointers to first and last components of the list
	 */
	struct mr_list_elt *first;
	struct mr_list_elt *last;
};

struct mr_list_elt {
	
	/* Content of the element in the list */
	void *data;

	/* Function to unallocate memory contained in data */
	void (*mr_free_data)(void *data);

	/* The neighbours (pointers to next and previous) */
	struct mr_list_elt *next;
	struct mr_list_elt *prev;
};


/* functions (public methods) */

void mr_list_alloc(struct mr_list *list);
void mr_list_alloc_elt(struct mr_list_elt *elt, void *data, void (*mr_free_data)(void *data));
void mr_list_free(struct mr_list *list);
void mr_list_free_elt(struct mr_list_elt *elt);
int mr_list_length(struct mr_list *list);
void mr_list_add_elt_first(struct mr_list *list, struct mr_list_elt *elt);
void mr_list_add_elt_last(struct mr_list *list, struct mr_list_elt *elt);
void mr_list_add_elt_after(struct mr_list *list, struct mr_list_elt *ref, struct mr_list_elt *elt);
void mr_list_add_elt_before(struct mr_list *list, struct mr_list_elt *ref, struct mr_list_elt *elt);
void mr_list_del_elt_first(struct mr_list *list);
void mr_list_del_elt_last(struct mr_list *list);
void mr_list_del_elt_after(struct mr_list *list, struct mr_list_elt *ref);
void mr_list_del_elt_before(struct mr_list *list, struct mr_list_elt *ref);

#endif							/* MR_LIST_H */
