/*
 * $Id$
 *
 * Code (c)2006 Bruno Cornec <bruno@mondorescue.org>
 *
 *     Main file of mr_err : a very small and simple
 *     library for error management
 *
 * Provided under the GPLv2
 */

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>

#include "mr_msg.h"

/* Pointer to the right cleanup function provided by each main */
extern void *mr_cleanup(void);

/*
 * Function that frees memory if necessary
 */
void mr_exit(int errorcode, const char *message) {

	mr_cleanup();
	if (message != NULL) {
		fprintf(stderr,"%s\n",message);
	}
	exit(errorcode);
}
