#!/usr/bin/perl -w
#
# $Id$
#
# mondo-web perl script 
# ======================
# The script is a cgi-bin script serving as a Web interface for mondoarchive
# It generates the right mondoarchive command depending on answers to questions
# it asks to the user.
#
# This program is free software and is made available under the GPLv2.
# (c) B. Cornec 2007
#

use strict;
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use Data::Dumper;
use AppConfig;
use AppConfig::File;

my $cgi = new CGI;

# Handling Configuration files
#my $file = "/etc/mondo/mondo.conf.dist";
#my $config = AppConfig->new();
#my $cfgfile = $config->file($file);
#$config->parse($file);            # read config file
#print Dumper($cfgfile);

# Fake it for now
my %media = (
		"CD" => "CD-R", 
		"CDRW" => "CD-RW", 
		"DVD" => "DVD+/-R/RW", 
		"ISO" => "ISO Image", 
		"USB" => "USB disk/key", 
		"TAPE" => "Tape", 
		"NFS" => "NFS File System", 
		"STREAM" => "Streaming"
);
my @media = sort keys %media;
my %options = (
		'FLOPPY' => 'Boot floppy production',
		'AUTO', => 'Auto Restore Mode',
		'NFSEXCL' => 'Exclude Network File Systems',
		'MANEJECT' => 'Manual media ejection',
		'DIFF' => 'Differential Backup',
		'VERIF' => 'Media verification (Slower)',
		'XATTR' => 'Extended Attributes and ACL Management (Slower)'
);
my @options = sort keys %options;
my %speed = (
		2 => '2x',
		4 => '4x',
		8 => '8x',
		16 => '16x',
		24 => '24x',
		48 => '48x',
		52 => '52x',
);
my @speed = sort {$a <=> $b} keys %speed;
my %comp = (
		GZIP => 'gzip (average)',
		BZIP2 => 'bzip2 (size)',
		LZO => 'lzo (speed)',
);
my @comp = sort keys %comp;
my %compsize = (
		0 => '0',
		1 => '1',
		2 => '2',
		3 => '3',
		4 => '4',
		5 => '5',
		6 => '6',
		7 => '7',
		8 => '8',
		9 => '9',
);
my @compsize = sort {$a <=> $b} keys %compsize;
my %boot = (
		'LILO' => "LILO (ELILO for ia64)",
		'GRUB' => "GRUB",
		'NATIVE' => "Autodetected",
);
my @boot = sort keys %boot;

print $cgi->header;
print $cgi->start_html('Web Based MondoArchive');
print << 'EOF';
<IMG SRC="mondo_logo.gif" HEIGHT=66 WIDTH=66 ALIGN=LEFT>
EOF
print $cgi->h1('MondoArchive Image Creation');

if (not ($cgi->param())) {
	print $cgi->start_form;
	print $cgi->hr;
	print $cgi->h2('Mandatory Info');
	print "<TABLE><TR><TD WIDTH=230>\n";
	print "Media type: ",$cgi->popup_menu(-name=>'media',
			-values=>\@media,
			-default=>$media[0],
			-labels=>\%media);
	print "</TD><TD WIDTH=300>\n";
	print "Destination path or device:\n";
	print $cgi->textfield(-name=>'dest',
				-default=>'',
				-size=>15,
				-maxlenght=>150);
	print "</TD><TD WIDTH=250>\n";
	print "Size of media (MB):\n";
	print $cgi->textfield(-name=>'size',
				-default=>'4380',
				-size=>6,
				-maxlenght=>6);
	print "</TD></TR></TABLE>\n";
	print $cgi->hr;

	print $cgi->h2('Compression Info');
	print "<TABLE><TR><TD WIDTH=330>\n";
	print "Compression tool: ",$cgi->popup_menu(-name=>'comp',
			-values=>\@comp,
			-default=>'GZIP',
			-labels=>\%comp);
	print "</TD><TD WIDTH=300>\n";
	print "Compression ratio: ",$cgi->popup_menu(-name=>'compsize',
			-values=>\@compsize,
			-default=>6,
			-labels=>\%compsize);
	print "</TD></TR></TABLE>\n";
	print $cgi->hr;

	print $cgi->h2('Optional Info');
	print "<TABLE><TR><TD WIDTH=360>\n";
	print $cgi->checkbox_group(-name=>'options',
			-values=>\@options,
			-defaults=>['NFSEXCL'],
			-linebreak=>'true',
			-labels=>\%options);
	print "</TD><TD WIDTH=350>\n";
	print "Temporary Directory:\n";
	print $cgi->textfield(-name=>'temp',
				-default=>'/var/cache/mondo/tmp',
				-size=>25,
				-maxlenght=>150);
	print "<BR>";
	print "Scratch Directory:\n";
	print $cgi->textfield(-name=>'scratch',
				-default=>'/var/cache/mondo/scratch',
				-size=>25,
				-maxlenght=>150);
	print "<BR>";
	print "ISO Image Name Prefix:\n";
	print $cgi->textfield(-name=>'prefix',
				-default=>'mondorescue',
				-size=>15,
				-maxlenght=>150);
	print "<BR>";
	print "Tape block size:\n";
	print $cgi->textfield(-name=>'block',
				-default=>'32768',
				-size=>10,
				-maxlenght=>10);
	print "<BR>";
	print "Media Speed (if pertinent): ",$cgi->popup_menu(-name=>'speed',
			-values=>\@speed,
			-default=>$speed[-1],
			-labels=>\%speed);
	print "<BR>";
	print "Kernel:\n";
	print $cgi->textfield(-name=>'kernel',
				-default=>'NATIVE',
				-size=>30,
				-maxlenght=>150);
	print "<BR>";
	print "Postnuke script:\n";
	print $cgi->textfield(-name=>'postnuke',
				-default=>'',
				-size=>30,
				-maxlenght=>150);
	print "<BR>";
	print "</TD></TR>\n";
	print "<TR><TD>\n";
	print "Bootloader:<BR>\n",$cgi->radio_group(-name=>'boot',
			-values=>\@boot,
			-default=>'NATIVE',
			-linebreak=>'true',
			-labels=>\%boot);
	print "</TD><TD>\n";
	print "Excluded directories:\n";
	print $cgi->textfield(-name=>'exclude',
				-default=>'',
				-size=>30,
				-maxlenght=>150);
	print "<BR>";
	print "Included directories:\n";
	print $cgi->textfield(-name=>'include',
				-default=>'',
				-size=>30,
				-maxlenght=>150);
	print "<BR>";
	print "Command to launch before burning:\n";
	print $cgi->textfield(-name=>'before',
				-default=>'',
				-size=>50,
				-maxlenght=>150);
	print "<BR>";
	print "Command to launch after burning:\n";
	print $cgi->textfield(-name=>'after',
				-default=>'',
				-size=>50,
				-maxlenght=>150);
	print "<BR>";
	print "</TD></TR></TABLE>\n";
	print $cgi->hr;
	print $cgi->submit;
	print $cgi->end_form;
} else {
	print $cgi->h2('You made the following choices :');
	print $cgi->hr;
	print "<BOLD>Mandatory options </BOLD> - ";
	print "Language : <em>",$cgi->param('language'),", </em>";
	print "Keyboard : <em>",$cgi->param('keyboard'),", </em>";
	print "Timezone : <em>",$cgi->param('timezone'),"</em>";
	print $cgi->hr;
	print "<BOLD>Network</BOLD> configuration mode ";
	if ($cgi->param('mode') eq 'STATIC') {
		print "<em>static</em><P>"; 
		print "Name : <em>",$cgi->param('name'),"</em><P>";
		print "IP address : <em>",$cgi->param('address'),", </em>";
		print "Netmask : <em>",$cgi->param('netmask'),"</em><P>";
		print "Gateway : <em>",$cgi->param('gateway'),", </em>";
		print "DNS server : <em>",$cgi->param('dns'),", </em>";
	}
	else {
		print "<em>dynamic (DHCP)</em>" 
	}
	print $cgi->hr;
	print "<BOLD>Services</BOLD> activated at boot time : ";
	foreach my $s ($cgi->param('options')) {
		print "- <em>FTP server</em> -" if ( $s =~ /FTP/);
		print "- <em>Web server</em> -" if ($s =~ /WWW/);
		print "- <em>DNS server</em> -" if ($s =~ /DNS/);
		print "- <em>Proxy/Cache server</em> -" if ($s =~ /SQUID/);
	}
	print $cgi->hr;
	print "Your customization parameters are now being commited to the server which will then reboot to ensure a proper environement.<P>";
	print "Please wait till it's done ...";
	print $cgi->end_form;

	#
	# Now doing the job ...
	#

		my $genbin = "/tmp";
		open(T,"> $genbin/populate") || die "Unable to open $genbin/populate";
		print T "#!/bin/sh\n";
		print T "#\n";

		foreach my $s ($cgi->param('services')) {
			print T "/sbin/chkconfig --level 345 named on\n" if ($s =~ /DNS/);
			print T "/sbin/chkconfig --level 345 httpd on\n" if ($s =~ /WWW/);
			print T "/sbin/chkconfig --level 345 squid on\n" if ($s =~ /SQUID/);
		}
		close(T);
		chmod 0755,"$genbin/populate";
		system("sudo $genbin/populate");
	}
