	/* libmondo-tools.h
	 * $Id: libmondo-tools.h 1144 2007-02-12 09:54:22Z bruno $
	 */

#ifndef LIBMONDO_TOOLS_H
# define LIBMONDO_TOOLS_H

void clean_up_KDE_desktop_if_necessary(void);

long get_time(void);
int read_cfg_var(char *config_file, char *label, char *value);
int write_cfg_var(char *config_file, char *label, char *value);
void reset_bkpinfo(struct s_bkpinfo *bkpinfo);
#ifdef __FreeBSD__
void initialize_raidrec(struct vinum_volume *vv);
#else
void initialize_raidrec(struct raid_device_record *raidrec);
#endif
int some_basic_system_sanity_checks(void);


void insmod_crucial_modules(void);
int find_and_store_mondoarchives_home(char *home_sz);


void unmount_supermounts_if_necessary(void);
void remount_supermounts_if_necessary(void);

int post_param_configuration(struct s_bkpinfo *bkpinfo);


int pre_param_configuration(struct s_bkpinfo *bkpinfo);

long free_space_on_given_partition(char *partition);



void mount_boot_if_necessary(void);
void unmount_boot_if_necessary(void);

void restart_autofs_if_necessary(void);
void malloc_libmondo_global_strings(void);
void free_libmondo_global_strings(void);

double get_kernel_version(void);
char *get_architecture(void);
bool does_nonMS_partition_exist(void);
void stop_magicdev_if_necessary(void);
void restart_magicdev_if_necessary(void);
void stop_autofs_if_necessary(void);
void restart_autofs_if_necessary(void);

#endif /* LIBMONDO_TOOLS_H */

