#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "mr_mem.h"
#include "mr_file.h"

void is_null(const char* str)
{
	if (str == NULL)
	      printf("pointer is null\n");
	else
	      printf("pointer is NOT null\n");
}

int main(void)
{
	char* str = NULL;
	FILE *fd = NULL;
	size_t n = 0;

	printf("*** Test with mr_malloc/mr_free\n");
	str = mr_malloc(10);
	is_null(str);
	mr_free(str);
	is_null(str);

	printf("*** Test with mr_asprintf/mr_free\n");
	mr_asprintf(&str,"Chain %s","of trust");
	printf("Result: %s\n",str);
	mr_free(str);

	printf("*** Test with mr_getline/mr_free\n");
	fd = mr_fopen("/etc/passwd","r");
	mr_getline(&str,&n,fd);
	printf("1st Result: %s",str);
	mr_getline(&str,&n,fd);
	printf("2nd Result: %s",str);
	mr_free(str);

	printf("*** Test with NULL\n");
	str = NULL;
	is_null(str);
	mr_free(str);
	is_null(str);

	return 0;
}

