/* 
 * $Id$
 *
 *     Header file of mr_mem: a set of function manipulating memory
 *     Provided under the GPL v2
 */

#ifndef MR_MEM_H
#define MR_MEM_H

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#include <stdarg.h>
#include <stdio.h>

/* functions (public methods) */

#define mr_free(x) mr_free_int((void **)&x,__LINE__,__FILE__)
#define mr_allocstr(x,y) mr_allocstr_int(x,y,__LINE__,__FILE__)
#define mr_asprintf(x,y,args...) mr_asprintf_int(x,__LINE__,__FILE__,y,## args)
#define mr_getline(x,y,z) mr_getline_int(x,y,z,__LINE__,__FILE__)
#define mr_malloc(x) mr_malloc_int((size_t)x,__LINE__,__FILE__)

/* Internal function bringing debuging info 
 * called indirectly through macros */
extern inline void mr_free_int(void **allocated, int line, char *file);
extern inline void mr_allocstr_int(char *alloc, const char *orig, int line, char *file);
extern inline void mr_asprintf_int(char **alloc, int line, char *file, const char *fmt, ...);
extern inline void mr_getline_int(char **lineptr, size_t *n, FILE *stream, int line, char *file);
extern inline void *mr_malloc_int(size_t size, int line, char *file);

#endif							/* MR_MEM_H */
