/*
 * $Id$
 *
 * Code (c)2006 Bruno Cornec <bruno@mondorescue.org>
 *
 *     Main file of mr_mem : a very small and simple
 *     library for memory management
 *
 * Provided under the GPLv2
 */

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>

#include "mr_err.h"
#include "mr_msg.h"

/*
 * Function that frees memory if necessary
 * A pointer to the memory pointed is passed to it.
 * *allocated variable points then to the original content 
 * pointed to by the caller
 */
void mr_free_int(void **allocated, int line, const char *file) {

	/* free man pages says that if allocated is NULL 
	 * nothing happens 
	 */
	if (*allocated != NULL) {
		free(*allocated);
		*allocated = NULL;
	} else {
		mr_msg_int(0,line,file,"Attempt to reference NULL pointer\nExiting...");
		mr_exit(-1,"Attempt to reference NULL pointer");
	}
}

/* encapsulation function for malloc */
void *mr_malloc_int(size_t size, int line, const char *file) {
	
	void *ret;

	ret = malloc(size);
	if (ret == NULL) {
		mr_msg_int(0,line,file,"Unable to alloc memory in mr_malloc\nExiting...");
		mr_exit(-1,"Unable to alloc memory in mr_malloc");
	}
	return(ret);
}

/* encapsulation function for getline */
void mr_getline_int(char **lineptr, size_t *n, FILE *stream, int line, const char *file) {
	
	ssize_t ret;

	ret = getline(lineptr,n,stream);
	if (ret == -1) {
		mr_msg_int(0,line,file,"Unable to alloc memory in mr_getline\nExiting...",line,file);
		mr_exit(-1,"Unable to alloc memory in mr_getline");
	}
}

/* encapsulation function for asprintf */
void mr_asprintf_int(char **strp, int line, const char *file, const char *fmt, ...) {

	int res = 0;
	va_list args;

	va_start(args,fmt);
	res = vasprintf(strp, fmt, args);
	if (res == -1) {
		mr_msg_int(0,line,file,"Unable to alloc memory in mr_asprintf\nExiting...",line,file);
		mr_exit(-1,"Unable to alloc memory in mr_asprintf");
	}
	va_end(args);
}

/*
 * Function that properly allocates a string from another one
 * freeing it before in any case
 */
void mr_allocstr_int(char *alloc, const char *orig, int line, const char *file) {

	mr_free_int((void **)&alloc, line, file); 
	mr_asprintf_int(&alloc, line, file, orig);
}
