/*
 * Test file to test the messages functions
 *
 * $Id$
 *
 */

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>

#include "mr_msg.h"
#include "mr_conf.h"
#include "mr_mem.h"

int main(void) {
	int ret = 0;
	char *s = NULL;
	int l = 0;
	char *str = NULL;
	size_t n = (size_t)0;
	FILE *fd = NULL;

	/* Get logfile name and log level from conf file */
	if ((ret = mr_conf_open("mondo.conf")) != 0) {
		fprintf(stderr,"Unable to open conf file (%d)\n",ret); 
		exit(-1);
	}
	if ((s = mr_conf_sread("logfile")) == NULL) {
		fprintf(stderr,"Unable to get string\n");
		exit(-1);
	}
	fprintf(stdout, "Logfile : ***%s***\n",s);
	l = mr_conf_iread("loglevel");
	fprintf(stdout, "Loglevel : ***%d***\n",l);
	mr_conf_close();

	/* test messages functions */
	mr_msg_init(s,l);

	mr_msg(1, "Log sentence : %d %d %s %s\n", 12, l, s, "is a log file");

	if ((fd = fopen(s,"r")) != NULL) {
		getline(&str, &n, fd);
		fprintf(stdout, "%s", str);
		mr_free(str);
		fclose(fd);
	} else {
		fprintf(stderr,"Unable to open file %s\n", s);
		exit(-1);
	}

	mr_free(s);
	mr_msg_close();
	exit(0);
}
