/*
 * $Id$
 *
 * Code (c)2006 Bruno Cornec <bruno@mondorescue.org>
 *
 *     Main file of mr_mem : a very small and simple
 *     library for memory management
 *
 * Provided under the GPLv2
 */

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>

#include "mr_err.h"
#include "mr_msg.h"

/*
 * Function that frees memory if necessary
 */
void mr_free(void *allocated) {

	/* free man pages says that if allocated is NULL 
	 * nothing happens 
	 */
	free(allocated);
	allocated = NULL;
}

/* encapsulation function for malloc */
void *mr_malloc(size_t size) {
	
	void *ret;

	ret = malloc(size);
	if (ret == NULL) {
		mr_log_exit(-1,"Unable to alloc memory in mr_malloc\nExiting...");
	}
	return(ret);
}

/* encapsulation function for getline */
void mr_getline(char **lineptr, size_t *n, FILE *stream) {
	
	ssize_t ret;

	ret = getline(lineptr,n,stream);
	if (ret == -1) {
		mr_log_exit(-1,"Unable to alloc memory in mr_getline\nExiting...");
	}
}

/* encapsulation function for asprintf */
void mr_asprintf(char **strp, const char *fmt, ...) {

	int res = 0;
	va_list args;

	va_start(args,fmt);
	res = vasprintf(strp, fmt, args);
	if (res == -1) {
		mr_log_exit(-1,"Unable to alloc memory in mr_asprintf\nExiting...");
	}
	va_end(args);
}

/*
 * Function that properly allocates a string from another one
 * freeing it before in any case
 */
void mr_allocstr(char *alloc, const char *orig) {

	mr_free((void *)alloc); 
	mr_asprintf(&alloc, orig);
}
