/* mr_conf.h
 *
 * $Id$
 *
 * based on parse_conf.h (c)2002-2004 Anton Kulchitsky  mailto:anton@kulchitsky.org
 * Review for mondorescue (c) 2006 Bruno Cornec <bruno@mondorescue.org>
 *   
 *     Header file of mr_conf: a very small and simple
 *     library for mondorescue configuration file reading
 *
 * Provided under the GPLv2
 */

#ifndef MR_CONF_H
#define MR_CONF_H

/* functions (public methods) */

/*initialization and closing*/
extern int mr_conf_open(const char *filename);
extern void mr_conf_close(void);

/*read integer number after string str in the current file*/
extern int mr_conf_iread(const char *field_name);

/*read double/float number after string str in the current file*/
extern double mr_conf_fread(const char *field_name);

/*
 * read string after string str in the current file.
 * This function allocates the string which has to be freed later on 
*/
extern char *mr_conf_sread(const char *field_name);

#endif							/* MR_CONF_H */
