#!/usr/bin/perl -w

use strict;
use POSIX "uname";

my ($sysname, $nodename, $release, $version, $machine ) = uname;
my $ver = "";
my $module = ""; 
my %modlist;
my $void = "";
my $allmodules = "";


if (not (defined $ARGV[0])) {
		$ver = $release;
} else {
		$ver = $ARGV[0];
}
open(LSMOD, "/sbin/lsmod |") or die "Unable to launch lsmod";
open(DEPMOD, "/sbin/depmod -n $ver |") or die "Unable to launch depmod";

while (<DEPMOD>) {
	($module, $modlist{$module}) = split(/:/);
	last if ($module =~ /^#/);
	#print "Analyzing $module\n";
}
while (<LSMOD>) {
	next if (/^Module/);
	($module, $void) = split(/ /);
	#print "Analyzing $module\n";
	$module = `/sbin/modinfo -n $module`;
	chomp($module);
	$allmodules .= $modlist{$module};
}
close(LSMOD);
close(DEPMOD);
$allmodules =~ s/\n/ /g;
$allmodules =~ s/  */ /g;
print "$allmodules\n";
