# Copyright 1999-2006 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Id$

inherit eutils flag-o-matic

DESCRIPTION="The rescue part of a program that creates emergency boot disks/CDs using your kernel, tools and modules."
HOMEPAGE="http://www.mondorescue.org"
SRC_URI="ftp://ftp.mondorescue.org/src/${P}.tar.gz"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~x86 ia64 -*"
DEPEND="virtual/libc"
RDEPEND=">=app-arch/bzip2-0.9
		sys-devel/binutils"

src_unpack() {
	unpack ${A} || die "Failed to unpack ${A}"
	cd "${S}"
	make oldconfig > /dev/null
}

src_compile() {
	# work around broken ass powerpc compilers
	emake EXTRA_CFLAGS="${CFLAGS}" busybox || die "build failed"
}

src_install() {
	# bundle up the symlink files for use later
	emake PREFIX="${D}/usr/share/mindi/rootfs" install || die
	rm _install/bin/busybox
	tar cf busybox-links.tar -C _install . || die
	insinto /usr/share/mindi
	doins busybox-links.tar || die
}

pkg_preinst() {
	mv "${D}"/usr/share/mindi/busybox-links.tar "${T}"/ || die
}

pkg_postinst() {
	cd "${T}" || die
	mkdir _install
	tar xf busybox-links.tar -C _install || die
	cp -vpPR _install/* /usr/share/mindi/rootfs/bin || die "copying links for ${x} failed"

	echo
}
