#!/usr/bin/perl -w #-d
#
# iostat graphing tool based on rrdtool
# (c) 2004 B. Cornec HP <bruno.cornec@hp.com>
# Licensed under the GPL or Artistic License
#
# Original Charter: Monitor CPU/Load/Net_eth0|2 (io/s)/Disk (io/s) 
# 1 mesure par 20 seconde
# So the script has been developped first with that context in mind
# trying to be generic enough to be expandable later on
# More work needs to be done, some code factorized, ...
#
use strict;		# Always :-)
use English;		# for $UID
use Data::Dumper;	# for debug
use Time::Local;	# for timestamp
use Date::Manip;	# for timestamp
use File::Basename;	# for file manageemnt
use Storable;		# for data exchange
use Config::Auto;	# for config file
use sario2rrd qw(create_attr create_gauge update_gauge);
			# local common functions

# Avoid localisation problems in sar
$ENV{LANG}="C";

#
# Begin of configuration options
#
my $dir = "sar2rrd"; 	# Place under the html dir of user apache
			# Under that directory you should have one
			# directory per machine and in it all the
			# files resulting form the sar and iostat
			# commands (saxx and ioxx). Look at the 
			# cron file and related script

my ($l,$p,$uid,$gid,$q,$c,$gc,$apache,$empty) = getpwnam("apache") or die "apache not in passwd file";
my $base = "$apache/html/$dir";
my $config = Config::Auto::parse("$base/$dir.conf");
my @machines = @{$config->{machines}};
my $shot = $config->{shot};

#
# End of configuration options
#
my $debug = 0;
foreach my $a (@ARGV) {
	$debug++ if ($a =~ /-v/);
	$| = 1;		# Flush STDOUT
}
#
my @day;
my %t;
my %attr;

print Dumper($config) if ($debug > 1);
mkdir $base,0755 if (not (-d $base));
chown $uid, $gid, $base || warn "Unable to chown $base to $uid" if ($UID == 0);
#
# data struct: hash per machine and per timestamp pointing to sar 
# and iostat values and a hash containing the  attributes
#

foreach my $m (@machines) {
	# Clean the table
	foreach my $ts (keys %t) {
		delete $t{$ts};
	}
	$attr{$m}{nbfields} = 0;
	#
	# The iostat file has to be the result of iostat -x -d 
	# This stores the iostat file content in the %t datastructure
	# 
	print "Getting iostat info for $m ( " if ($debug > 0);
	foreach my $d (<$base/$m/io[0-9][0-9]>) {
		print basename($d)." " if ($debug > 0);
		my $tmst = "";
		open(IOSTAT,"$d") || die "Unable to open $d";
		while (<IOSTAT>) {
			s/ +/ /g;
			my ($dev,$rrqm,$wrqm,$r,$w,$rsec,$wsec,$rkb,$wkb,$rqsz,$qusz,$await,$svctm,$util) = split / /;
			chomp($util) if defined($util);
			#
			# This line gives the day
			#
			if ($dev =~ /^Linux/) {
				chomp($r);
				$r =~ s/\t//g;
				@day = split(/\//,$r);
				print "Day:".Dumper(@day) if ($debug > 3);
				next;
			}
			next if ($dev =~ /^Device:/);
			next if ($dev =~ /^$/);
			#
			# This line gives the timestamp
			#
			if ($dev =~ /^Time:/) {
				$tmst = timelocal(reverse(split(/:/,$rrqm)),$day[1],$day[0]-1,$day[2]+2000);
				print "tmst: $tmst\n" if ($debug > 3);
				next;
			}
			$dev =~ s|^/dev/||;
			next if (($dev =~ /[0-9]$/) && ($dev !~ /cciss/));
			next if (($dev =~ /p[0-9]$/) && ($dev =~ /cciss/));
			$t{$tmst}{$dev."-in"} = $r;
			$t{$tmst}{$dev."-out"} = $w;
		}
		close(IOSTAT);
	}
	print ")\n" if ($debug > 0);

	#
	# Then create hash attributes + rrd base + update it
	#
	create_attr(\%t,\%attr,$m,$shot,$debug);
	create_gauge(\%t,\%attr,$config->{step},"$base/$m/$config->{rrdio}",$uid,$gid,$m,$debug);
	update_gauge(\%t,\%attr,"$base/$m/$config->{rrdio}",$m,$debug);
}
store (\%attr,"$base/$config->{svgio}") || die "Unable to store attr structure: $!";
print "Please launch sar2html now to get graphs in HTML pages\n" if ($debug > 0);
